<div class="row">
    <div class="col-lg-4 col-sm-12 mb-5">
        <?php echo e(Form::label('client_id', __('messages.invoice.client') . ':', ['class' => 'form-label required mb-3'])); ?>

        <?php echo e(Form::select('client_id', $clients, $client_id ?? null, ['class' => 'form-select io-select2', 'id' => 'client_id', 'placeholder' => __('messages.invoice.client'), 'data-control' => 'select2'])); ?>

    </div>
    <div class="col-lg-4 col-sm-12 mb-lg-0 mb-5">
        <?php if(!empty(getInvoiceNoPrefix()) || !empty(getInvoiceNoSuffix())): ?>
            <div class="" data-bs-toggle="tooltip" data-bs-trigger="hover" title=""
                data-bs-original-title="invoice number">
                <div class="form-group col-sm-12 mb-5">
                    <?php echo e(Form::label('paid_amount', __('messages.invoice.invoice_number') . ':', ['class' => 'form-label mb-3 required'])); ?>

                    <div class="input-group">
                        <?php if(!empty(getInvoiceNoPrefix())): ?>
                            <a class="input-group-text bg-secondary border-0 text-decoration-none text-black"
                                data-toggle="tooltip" data-placement="right" title="Invoice No Prefix">
                                <?php echo e(getInvoiceNoPrefix()); ?>

                            </a>
                        <?php endif; ?>
                        <?php echo e(Form::text('invoice_id', \App\Models\Invoice::generateUniqueInvoiceId(), ['class' => 'form-control', 'required', 'id' => 'invoiceId', 'maxlength' => 6, 'onkeypress' => 'return blockSpecialChar(event)'])); ?>

                        <?php if(!empty(getInvoiceNoSuffix())): ?>
                            <a class="input-group-text bg-secondary border-0 text-decoration-none text-black"
                                data-toggle="tooltip" data-placement="right" title="Invoice No Suffix">
                                <?php echo e(getInvoiceNoSuffix()); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="" data-bs-toggle="tooltip" data-bs-trigger="hover"
                data-bs-original-title="invoice number">
                <span class="form-label"><?php echo e(__('messages.invoice.invoice')); ?> #</span>
                <?php echo e(Form::text('invoice_id', \App\Models\Invoice::generateUniqueInvoiceId(), ['class' => 'form-control mt-3', 'required', 'id' => 'invoiceId', 'maxlength' => 6, 'onkeypress' => 'return blockSpecialChar(event)'])); ?>

            </div>
        <?php endif; ?>
    </div>
    
    
    <div class="col-lg-4 col-sm-12 mb-5">
        <?php echo e(Form::label('invoice_date', __('messages.invoice.invoice_date') . ':', ['class' => 'form-label required mb-3'])); ?>

        <?php echo e(Form::text('invoice_date', null, ['class' => 'form-select', 'id' => 'invoice_date', 'autocomplete' => 'off', 'required'])); ?>

    </div>
    <div class="mb-5 col-lg-4 col-sm-12">
        <?php echo e(Form::label('due_date', __('messages.invoice.due_date') . ':', ['class' => 'form-label required mb-3'])); ?>

        <?php echo e(Form::text('due_date', null, ['class' => 'form-select', 'id' => 'due_date', 'autocomplete' => 'off', 'required'])); ?>

    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="mb-5">
            <?php echo e(Form::label('status', __('messages.common.status') . ':', ['class' => 'form-label required mb-3'])); ?>

            <?php echo e(Form::select('status', $statusArr, null, ['class' => 'form-select io-select2', 'id' => 'status', 'required', 'data-control' => 'select2'])); ?>

        </div>
    </div>
    <div class="mb-5 col-lg-4 col-sm-12">
        <?php echo e(Form::label('templateId', __('messages.setting.invoice_template') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::select('template_id', $template, getInvoiceSettingTemplateId() ?? null, ['class' => 'form-select io-select2', 'id' => 'templateId', 'required', 'data-control' => 'select2'])); ?>

    </div>
    <div class="mb-5 col-lg-4 col-sm-12">
        <?php echo e(Form::label('payment_qr_code_id', __('messages.payment_qr_codes.payment_qr_code') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::select('payment_qr_code_id', $paymentQrCodes, $defaultPaymentQRCode ?? null, ['class' => 'form-select io-select2 payment-qr-code', 'data-control' => 'select2', 'placeholder' => __('messages.flash.select_payment_qr_code')])); ?>

    </div>
    <div class="mb-5 col-lg-4 col-sm-12">
        <?php echo e(Form::label('currencyType', __('messages.setting.currencies') . ':', ['class' => 'form-label mb-3'])); ?>

        <select id="currencyType" class="form-select invoice-currency-type" name="currency_id">
            <option value=""><?php echo e(__('messages.flash.select_currency')); ?></option>
            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($currency['id']); ?>"><?php echo e($currency['icon']); ?>

                    &nbsp;&nbsp;&nbsp; <?php echo e($currency['name']); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="mb-5 col-lg-4 col-sm-12 mt-8">
        <label class="form-check form-switch form-check-custom mt-3">
            <input class="form-check-input recurring-status" type="checkbox" name="recurring_status"
                id="recurringStatusToggle">
            <span class="form-check-label text-gray-600"
                for="recurringStatusToggle"><?php echo e(__('messages.invoice.this_is_recurring_invoice')); ?></span>&nbsp;&nbsp;
        </label>
    </div>
    <div class="mb-5 col-lg-4 col-sm-12 recurring-cycle-content">
        <?php echo e(Form::label('recurringCycle', __('messages.invoice.recurring_cycle') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::number('recurring_cycle', null, ['class' => 'form-control', 'id' => 'recurringCycle', 'autocomplete' => 'off', 'placeholder' => __('messages.flash.number_of_days_for_recurring_cycle'), 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))"])); ?>

    </div>
    
    
    <div class="mb-0">
        <div class="col-12 text-end mb-lg-8 mb-6">
            <button type="button" class="btn btn-primary text-start" id="addItem">
                <?php echo e(__('messages.invoice.add')); ?></button>
        </div>
        <div class="table-responsive">
            <table class="table table-striped box-shadow-none mt-4" id="billTbl">
                <thead>
                    <tr class="border-bottom fs-7 fw-bolder text-gray-700 text-uppercase">
                        <th scope="col">#</th>
                        <th scope="col" class="required"><?php echo e(__('messages.product.product')); ?></th>
                        <th scope="col" class="required"><?php echo e(__('messages.invoice.qty')); ?></th>
                        <th scope="col" class="required"><?php echo e(__('messages.product.unit_price')); ?></th>
                        <th scope="col"><?php echo e(__('messages.invoice.tax')); ?></th>
                        <th scope="col" class="required"><?php echo e(__('messages.invoice.amount')); ?></th>
                        <th scope="col" class="text-end"><?php echo e(__('messages.common.action')); ?></th>
                    </tr>
                </thead>
                <tbody class="invoice-item-container">
                    <tr class="tax-tr">
                        <td class="text-center item-number align-center">1</td>
                        <td class="table__item-desc w-25">
                            <?php echo e(Form::select('product_id[]', $products, null, ['class' => 'form-select product io-select2', 'required', 'placeholder' => __('messages.flash.select_product_or_enter_free_text'), 'data-control' => 'select2'])); ?>

                        </td>
                        <td class="table__qty">
                            <?php echo e(Form::number('quantity[]', null, ['class' => 'form-control qty ', 'required', 'type' => 'number', 'min' => '0', 'step' => '.01', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))"])); ?>

                        </td>
                        <td>
                            <?php echo e(Form::number('price[]', null, ['class' => 'form-control price-input price ', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))", 'min' => '0', 'value' => '0', 'step' => '.01', 'pattern' => "^\d*(\.\d{0,2})?$", 'required', 'onKeyPress' => 'if(this.value.length==8) return false;'])); ?>

                        </td>
                        <td>
                            <select name="tax[]" class='form-select io-select2 fw-bold tax' data-control='select2'
                                multiple="multiple">
                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tax->value); ?>" data-id="<?php echo e($tax->id); ?>"
                                        <?php echo e($defaultTax == $tax->id ? 'selected' : ''); ?>><?php echo e($tax->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td class="text-end item-total pt-8 text-nowrap">
                            <?php if(!getSettingValue('currency_after_amount')): ?>
                                <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                            <?php endif; ?> 0.00
                            <?php if(getSettingValue('currency_after_amount')): ?>
                                <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="text-end">
                            <button type="button" title="Delete"
                                class="btn btn-icon fs-3 text-danger btn-active-color-danger delete-invoice-item">
                                <i class="fa-solid fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="row">
            <div class="col-lg-7 col-sm-12 mt-2 mt-lg-0 align-right-for-full-screen">
                <div class="mb-2 col-xl-5 col-lg-8 col-sm-12 float-right">
                    <?php echo e(Form::label('discount', __('messages.invoice.discount') . ':', ['class' => 'form-label mb-1'])); ?>

                    <div class="input-group">
                        <?php echo e(Form::number('discount', 0, ['id' => 'discount', 'class' => 'form-control ', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))", 'min' => '0', 'value' => '0', 'step' => '.01', 'pattern' => "^\d*(\.\d{0,2})?$"])); ?>

                        <div class="input-group-append" style="width: 210px !important;">
                            <?php echo e(Form::select('discount_type', $discount_type, 0, ['class' => 'form-select io-select2 discount-type', 'id' => 'discountType', 'data-control' => 'select2'])); ?>

                        </div>
                    </div>
                </div>
                <div class="mb-2 col-xl-5 col-lg-8 col-sm-12 float-right">
                    <?php echo e(Form::label('tax2', __('messages.invoice.tax') . ':', ['class' => 'form-label mb-1'])); ?>

                    <select name="taxes[]" class='form-select io-select2 fw-bold invoice-taxes' data-control='select2'
                        multiple="multiple">
                        <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($tax->id); ?>" data-tax="<?php echo e($tax->value); ?>"><?php echo e($tax->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-xxl-3 col-lg-5 col-md-6 ms-md-auto mt-4 mb-lg-10 mb-6">
                <div class="border-top">
                    <table class="table table-borderless box-shadow-none mb-0 mt-5">
                        <tbody>
                            <tr>
                                <td class="ps-0"><?php echo e(__('messages.invoice.sub_total') . ':'); ?></td>
                                <td class="text-gray-900 text-end pe-0">
                                    <?php if(!getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?> <span id="total" class="price">
                                        0
                                    </span>
                                    <?php if(getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="ps-0"><?php echo e(__('messages.invoice.discount') . ':'); ?></td>
                                <td class="text-gray-900 text-end pe-0">
                                    <?php if(!getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?> <span id="discountAmount">
                                        0
                                    </span>
                                    <?php if(getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="ps-0"><?php echo e(__('messages.invoice.total_tax') . ':'); ?></td>
                                <td class="text-gray-900 text-end pe-0">
                                    <?php if(!getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?> <span id="totalTax">
                                        0
                                    </span>
                                    <?php if(getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="ps-0"><?php echo e(__('messages.invoice.total') . ':'); ?></td>
                                <td class="text-gray-900 text-end pe-0">
                                    <?php if(!getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?> <span id="finalAmount">
                                        0
                                    </span>
                                    <?php if(getSettingValue('currency_after_amount')): ?>
                                        <span class="invoice-selected-currency"><?php echo e(getCurrencySymbol()); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row justify-content-left mt-lg-2 mt-0">
            <div class="col-lg-12 col-md-12 col-sm-12 end justify-content-left mb-sm-0 mb-5">
                <button type="button" class="btn btn-primary note" id="addNote"><i class="fas fa-plus"></i>
                    <?php echo e(__('messages.invoice.add_note_term')); ?></button>
                <button type="button" class="btn btn-danger note" id="removeNote"><i class="fas fa-minus"></i>
                    <?php echo e(__('messages.invoice.remove_note_term')); ?></button>
            </div>
            <div class="col-lg-6 mb-0 mb-sm-5 mt-0 mt-sm-5" id="noteAdd">
                <?php echo e(Form::label('note', __('messages.invoice.note') . ':', ['class' => 'form-label fs-6 mb-3'])); ?>

                <?php echo e(Form::textarea('note', null, ['class' => 'form-control', 'id' => 'note', 'rows' => '5'])); ?>

            </div>
            <div class="col-lg-6 mb-5 mt-5" id="termRemove">
                <?php echo e(Form::label('term', __('messages.invoice.terms') . ':', ['class' => 'form-label fs-6 mb-3'])); ?>

                <?php echo e(Form::textarea('term', null, ['class' => 'form-control', 'id' => 'term', 'rows' => '5'])); ?>

            </div>
        </div>
    </div>
</div>
<!-- Total Amount Field -->
<?php echo e(Form::hidden('amount', 0, ['class' => 'form-control', 'id' => 'total_amount'])); ?>

<!-- Final Amount Field -->
<?php echo e(Form::hidden('final_amount', 0, ['class' => 'form-control', 'id' => 'finalTotalAmt'])); ?>

<!-- Submit Field -->
<div class="float-end">
    <div class="form-group col-sm-12">
        <button type="button" name="draft" class="btn btn-primary mx-1 ms-ms-3 mb-3 mb-sm-0" id="saveAsDraft"
            data-status="0" value="0"><?php echo e(__('messages.common.save_draft')); ?>

        </button>
        <button type="button" name="save" class="btn btn-primary mx-1 ms-ms-3 mb-3 mb-sm-0" id="saveAndSend"
            data-status="1" value="1"><?php echo e(__('messages.common.save_send')); ?>

        </button>
        <a href="<?php echo e(route('invoices.index')); ?>"
            class="btn btn-secondary btn-active-light-primary"><?php echo e(__('messages.common.cancel')); ?></a>
    </div>
</div>
<?php /**PATH /home/tech4ideanet/public_html/demos/invoices/resources/views/invoices/fields.blade.php ENDPATH**/ ?>