<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.currency_reports')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <h1 class="mb-5 text-center"><?php echo e(__('messages.admin_dashboard.total_amount')); ?></h1>
                            <div class="d-flex align-items-center flex-column">
                                <?php if(count($currencyData['totalInvoices']) > 0): ?>
                                    <?php $__currentLoopData = $currencyData['totalInvoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currencyId => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="bg-success shadow-md rounded-10 custom-widget custom-widget d-flex align-items-center justify-content-center my-3 w-65">
                                            <div class="d-flex align-items-center text-white">
                                                <h2 class="fs-1-xxl fw-bolder text-white mb-0">
                                                    <?php echo e(getInvoiceCurrencyAmount($amount, $currencyId)); ?>

                                                </h2>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <p class="fs-3 mt-9"><?php echo e(__('messages.invoice.nothing_amount_yet')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6 mt-sm-0 mt-5">
                            <h1 class="mb-5 text-center"><?php echo e(__('messages.admin_dashboard.total_paid')); ?></h1>
                            <div class="d-flex align-items-center flex-column">
                                <?php if(count($currencyData['paidInvoices']) > 0): ?>
                                    <?php $__currentLoopData = $currencyData['paidInvoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currencyId => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="bg-info shadow-md rounded-10 custom-widget d-flex align-items-center justify-content-center my-3 w-65">
                                            <div class="d-flex align-items-center text-white">
                                                <h2 class="fs-1-xxl fw-bolder text-white mb-0">
                                                    <?php echo e(getInvoiceCurrencyAmount($amount, $currencyId)); ?>

                                                </h2>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <p class="fs-3 mt-9"><?php echo e(__('messages.invoice.nothing_paid_yet')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6 mt-md-0 mt-sm-0 mt-5 mt-lg-5 mt-md-5 mt-xl-0">
                            <h1 class="mb-5 text-center"><?php echo e(__('messages.admin_dashboard.total_due')); ?></h1>
                            <div class="d-flex align-items-center flex-column">
                                <?php if(count($currencyData['dueInvoices']) > 0): ?>
                                    <?php $__currentLoopData = $currencyData['dueInvoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currencyId => $dueInvoiceAmount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="bg-warning shadow-md rounded-10 custom-widget d-flex align-items-center justify-content-center my-3 w-65">
                                            <div class="d-flex align-items-center text-white">
                                                <h2 class="fs-1-xxl fw-bolder text-white mb-0">
                                                    <?php echo e(getInvoiceCurrencyAmount($dueInvoiceAmount, $currencyId)); ?>

                                                </h2>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <p class="fs-3 mt-9"><?php echo e(__('messages.invoice.nothing_due_yet')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tech4ideanet/public_html/demos/invoices/resources/views/dashboard/currency_reports.blade.php ENDPATH**/ ?>