/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.messages":{"add_admin":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0634\u0631\u0641","admin":"\u0645\u0634\u0631\u0641","admin_dashboard":{"dashboard":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0642\u064a\u0627\u062f\u0629","day":"\u064a\u0648\u0645","income_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u062e\u0644","invoice_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631","month":"\u0627\u0644\u0634\u0647\u0631","monthly_income_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u062e\u0644 \u0627\u0644\u0634\u0647\u0631\u064a","name":"\u0627\u0644\u0627\u0633\u0645","no_record_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0623\u064a \u0633\u062c\u0644","payment_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u0641\u0639","registered":"\u0645\u064f\u0633\u062c\u064e\u0651\u0644","total_amount":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0628\u0644\u063a","total_clients":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0639\u0645\u0644\u0627\u0621","total_due":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0628\u0627\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642\u0629","total_invoices":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631","total_overdue_invoice":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062a\u0623\u062e\u0631\u0629","total_paid":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0627\u062a","total_paid_invoices":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0629","total_partial_paid_invoices":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0629 \u062c\u0632\u0626\u064a\u064b\u0627","total_payments":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0627\u062a","total_products":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0646\u062a\u062c\u0627\u062a","total_unpaid_invoices":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u063a\u064a\u0631 \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0629","week":"\u0623\u0633\u0628\u0648\u0639","year":"\u0639\u0627\u0645","yearly_income_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u062e\u0644 \u0627\u0644\u0633\u0646\u0648\u064a"},"admin_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","admins":"\u0645\u062f\u0631\u0627\u0621","apps":"\u062a\u0637\u0628\u064a\u0642\u0627\u062a","categories":"\u0641\u0626\u0627\u062a","category":{"add_category":"\u0625\u0636\u0627\u0641\u0629 \u0641\u0626\u0629","category":"\u0627\u0644\u0641\u0626\u0629","edit_category":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0641\u0626\u0629"},"change_avatar":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","change_language":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629","cities":"\u0627\u0644\u0645\u062f\u0646","clear_cache":"\u0645\u0633\u062d \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u062a\u062e\u0632\u064a\u0646 \u0627\u0644\u0645\u0624\u0642\u062a","client":{"add_client":"\u0625\u0636\u0627\u0641\u0629 \u0639\u0645\u064a\u0644","add_user":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0633\u062a\u062e\u062f\u0645","address":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646","city":"\u0645\u062f\u064a\u0646\u0629","client":"\u0627\u0644\u0639\u0645\u064a\u0644","client_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0639\u0645\u064a\u0644","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_no":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","country":"\u0627\u0644\u0628\u0644\u062f","created_at":"\u0627\u0644\u062a\u0627\u0631\u064a\u062e","edit_user":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0639\u0636\u0648","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","gender":"\u0627\u0644\u0646\u0648\u0639","last_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0627\u0626\u0644\u0629","male":"\u0630\u0643\u0631","note":"\u0645\u0644\u0627\u062d\u0638\u0629","notes":"\u0645\u0644\u0627\u062d\u0638\u0627\u062a","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","postal_code":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","role":"\u0648\u0638\u064a\u0641\u0629","state":"\u0648\u0644\u0627\u064a\u0629","website":"\u0645\u0648\u0642\u0639 \u0648\u064a\u0628"},"client_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0639\u0645\u064a\u0644","clients":"\u0627\u0644\u0639\u0645\u0644\u0627\u0621","common":{"action":"\u0627\u0644\u0625\u062c\u0631\u0627\u0621","actions":"\u0627\u0644\u0625\u062c\u0631\u0627\u0621\u0627\u062a","active":"\u0646\u0634\u0637","add":"\u064a\u0636\u064a\u0641","address":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646","allow_file_type":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627","apply":"\u064a\u062a\u0642\u062f\u0645","are_you_sure_delete":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","attachment":"\u062d\u0627\u062c\u0632","back":"\u0631\u062c\u0648\u0639","cancel":"\u0625\u0644\u063a\u0627\u0621","city":"\u0645\u062f\u064a\u0646\u0629","click_here":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627","country":"\u0627\u0644\u0628\u0644\u062f","created_at":"\u062e\u0644\u0642\u062a","custom":"\u0627\u0644\u0639\u0627\u062f\u0629","de_active":"\u063a\u064a\u0631 \u0646\u0634\u0637","default":"\u0627\u0641\u062a\u0631\u0627\u0636\u064a","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","details":"\u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644","discard":"\u062a\u062c\u0627\u0647\u0644","edit":"\u062a\u062d\u0631\u064a\u0631","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","error":"\u062e\u0637\u0623","filter":"\u062a\u0635\u0641\u064a\u0629","filter_options":"\u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u062a\u0635\u0641\u064a\u0629","from":"\u0645\u0646","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","invoice":"\u0641\u0627\u062a\u0648\u0631\u0629","last_update":"\u0622\u062e\u0631 \u062a\u062d\u062f\u064a\u062b","mo":"\u0645\u0648","n\/a":"\u063a\u064a\u0631 \u0645\u062a\u0627\u062d","name":"\u0627\u0644\u0627\u0633\u0645","no_cancel":"\u0644\u0627 \u0625\u0644\u063a\u0627\u0621","ok":"\u0645\u0648\u0627\u0641\u0642","pay":"\u062f\u0641\u0639","payment_type":"\u0646\u0648\u0639 \u0627\u0644\u062f\u0641\u0639","please_wait":"\u0623\u0631\u062c\u0648 \u0627\u0644\u0625\u0646\u062a\u0638\u0627\u0631...","regards":"\u064a\u0639\u062a\u0628\u0631","reminder":"\u062a\u0630\u0643\u064a\u0631","reset":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646","save":"\u062d\u0641\u0638","save_draft":"\u062d\u0641\u0638 \u0643\u0645\u0633\u0648\u062f\u0629","save_send":"\u062d\u0641\u0638 \u0648\u0625\u0631\u0633\u0627\u0644","search":"\u064a\u0628\u062d\u062b","service":"\u0627\u0644\u062e\u062f\u0645\u0629","state":"\u0648\u0644\u0627\u064a\u0629","status":"\u0627\u0644\u062d\u0627\u0644\u0629","submit":"\u0625\u0631\u0633\u0627\u0644","this_weeks":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","to":"\u0625\u0644\u0649","updated_at":"\u0645\u062d\u062f\u062b","value":"\u0627\u0644\u0642\u064a\u0645\u0629","yes_delete":"\u0646\u0639\u0645 \u060c \u0627\u062d\u0630\u0641!","zipcode":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a"},"countries":"\u0627\u0644\u0628\u0644\u062f\u0627\u0646","currency":{"add_currency":"\u0623\u0636\u0641 \u0639\u0645\u0644\u0629","currency":"\u0639\u0645\u0644\u0629","currency_code":"\u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629","edit_currency":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","icon":"\u0631\u0645\u0632"},"currency_reports":"\u062a\u0642\u0627\u0631\u064a\u0631 \u0627\u0644\u0639\u0645\u0644\u0627\u062a","dashboard":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0642\u064a\u0627\u062f\u0629","datepicker":{"custom":"\u0646\u0637\u0627\u0642 \u0645\u062e\u0635\u0635","last_30_days":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_7_days":"\u0627\u062e\u0631 7 \u0627\u064a\u0627\u0645","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","today":"\u0627\u0644\u064a\u0648\u0645","yesterday":"\u0623\u0645\u0633"},"edit_admin":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0634\u0631\u0641","flash":{"Admin_cant_be_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","Admin_deleted_successfully":"\u062d\u0630\u0641 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d","Invoice_send_successfully":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","admin_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d","admin_profile_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d","admin_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d","all_notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u0625\u0634\u0639\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d","allowed_file_types_png_jpg_jpeg":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","application_cache_cleared":"\u062a\u0645 \u0645\u0633\u062d \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u062a\u062e\u0632\u064a\u0646 \u0627\u0644\u0645\u0624\u0642\u062a \u0644\u0644\u062a\u0637\u0628\u064a\u0642!","are_sure_want_to_delete_this_client_related_all_invoices":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u062c\u0645\u064a\u0639 \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062a\u0639\u0644\u0642\u0629 \u0628\u0647\u0630\u0627 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","category_cant_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0641\u0626\u0629.","category_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","category_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","category_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","category_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","cities_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u062f\u0646 \u0628\u0646\u062c\u0627\u062d","click_refresh_icon_generate_product_code":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0631\u0645\u0632 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0644\u0625\u0646\u0634\u0627\u0621 \u0631\u0645\u0632 \u0627\u0644\u0645\u0646\u062a\u062c","client_cant_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0639\u0645\u064a\u0644.","client_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0639\u0645\u064a\u0644 \u0628\u0646\u062c\u0627\u062d","client_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0639\u0645\u064a\u0644 \u0628\u0646\u062c\u0627\u062d","client_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0639\u0645\u064a\u0644 \u0628\u0646\u062c\u0627\u062d","converted_quote_can_not_editable":"\u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633 \u0627\u0644\u0645\u062d\u0648\u0644 \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0639\u062f\u064a\u0644\u0647","converted_to_invoice_successfully":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0648\u064a\u0644 \u0625\u0644\u0649 \u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","currency_cant_deleted":"\u064a\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0639\u0645\u0644\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631","currency_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d","currency_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","currency_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d","current_password_is_invalid":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629","default_admin_can_not_editable":"\u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0639\u062f\u064a\u0644\u0647","invoice_currency_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0639\u0645\u0644\u0629 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","invoice_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","invoice_due_amount_retrieve_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0645\u0628\u0644\u063a \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0645\u0633\u062a\u062d\u0642\u0629 \u0628\u0646\u062c\u0627\u062d","invoice_saved_and_sent_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0648\u0625\u0631\u0633\u0627\u0644\u0647\u0627 \u0628\u0646\u062c\u0627\u062d","invoice_saved_successfully":"\u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0645\u062d\u0641\u0648\u0638\u0629 \u0628\u0646\u062c\u0627\u062d","invoice_template_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","invoice_updated_and_send_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0648\u0625\u0631\u0633\u0627\u0644\u0647\u0627 \u0628\u0646\u062c\u0627\u062d","invoice_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","language_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","manual_payment_approved_successfully":"\u062a\u0645\u062a \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a \u0628\u0646\u062c\u0627\u062d","manual_payment_denied_successfully":"\u062a\u0645 \u0631\u0641\u0636 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a \u0628\u0646\u062c\u0627\u062d","note_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0628\u0646\u062c\u0627\u062d","notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631 \u0628\u0646\u062c\u0627\u062d","number_of_days_for_recurring_cycle":"\u0639\u062f\u062f \u0623\u064a\u0627\u0645 \u0627\u0644\u062f\u0648\u0631\u0629 \u0627\u0644\u0645\u062a\u0643\u0631\u0631\u0629","password_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631 \u0628\u0646\u062c\u0627\u062d","payment_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d.","payment_overview_status_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u062d\u0627\u0644\u0629 \u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","payment_qr_code_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","payment_qr_code_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","payment_qr_code_status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","payment_qr_code_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","payment_reminder_mail_send_successfully":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0628\u0631\u064a\u062f \u062a\u0630\u0643\u064a\u0631 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","payment_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d.","payment_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d.","product_cant_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0645\u0646\u062a\u062c.","product_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0646\u062a\u062c \u0628\u0646\u062c\u0627\u062d","product_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0646\u062a\u062c \u0628\u0646\u062c\u0627\u062d","product_price_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0633\u0639\u0631 \u0627\u0644\u0645\u0646\u062a\u062c \u0628\u0646\u062c\u0627\u062d","product_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0646\u062a\u062c \u0628\u0646\u062c\u0627\u062d","quote_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633 \u0628\u0646\u062c\u0627\u062d","quote_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633 \u0628\u0646\u062c\u0627\u062d","quote_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633 \u0628\u0646\u062c\u0627\u062d","recurring_status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0627\u0644\u0645\u062a\u0643\u0631\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","seems_you_are_not_allowed_to_access_this_record":"\u064a\u0628\u062f\u0648 \u0623\u0646\u0647 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0644\u0643 \u0628\u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0633\u062c\u0644.","select_currency":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","select_payment_qr_code":"\u0627\u062e\u062a\u0631 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639","select_product_or_enter_free_text":"\u0627\u062e\u062a\u0631 \u0645\u0646\u062a\u062c\u064b\u0627 \u0623\u0648 \u0623\u062f\u062e\u0644 \u0646\u0635\u064b\u0627 \u062d\u0631\u064b\u0627","setting_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0639\u062f\u0627\u062f \u0628\u0646\u062c\u0627\u062d","status_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d","status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d","tax_can_not_deleted":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628 \u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641\u0647\u0627.","tax_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0628\u0646\u062c\u0627\u062d","tax_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0628\u0646\u062c\u0627\u062d","tax_saved_successfully":"\u062a\u0645 \u062a\u0648\u0641\u064a\u0631 \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0628\u0646\u062c\u0627\u062d","tax_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0628\u0646\u062c\u0627\u062d","yearly_income_overview_chart_data_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0631\u0633\u0645 \u0627\u0644\u0628\u064a\u0627\u0646\u064a \u0627\u0644\u0633\u0646\u0648\u064a \u0644\u0644\u062f\u062e\u0644 \u0628\u0646\u062c\u0627\u062d"},"general":"\u0639\u0627\u0645","invoice":{"add":"\u064a\u0636\u064a\u0641","add_note_term":"\u0623\u0636\u0641 \u0645\u0644\u0627\u062d\u0638\u0629 \u0648\u0634\u0631\u0648\u0637","amount":"\u0627\u0644\u0645\u0628\u0644\u063a","amount_should_be_less_than_payable_amount":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642.","are_you_sure_send":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u0633\u0627\u0644 \u0647\u0630\u0647 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0625\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","client":"\u0627\u0644\u0639\u0645\u064a\u0644","client_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0644\u0639\u0645\u064a\u0644","client_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0645\u064a\u0644","client_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644","copy_invoice_url":"\u0627\u0646\u0633\u062e \u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0641\u0627\u062a\u0648\u0631\u0629","discount":"\u0627\u0644\u062e\u0635\u0645","discount_type":"\u0646\u0648\u0639 \u0627\u0644\u062e\u0635\u0645","download":"\u062a\u0646\u0632\u064a\u0644","due_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642","due_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0633\u062a\u062d\u0642\u0627\u0642","edit_invoice":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","excel_export":"\u062a\u0635\u062f\u064a\u0631 \u0627\u0643\u0633\u0644","fax_no":"\u0631\u0642\u0645 \u0627\u0644\u0641\u0627\u0643\u0633","has_been_sent":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644\u0647.","invoice":"\u0641\u0627\u062a\u0648\u0631\u0629","invoice_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoice_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoice_id":"\u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoice_number":"\u0631\u0642\u0645 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoice_pdf":"\u0641\u0627\u062a\u0648\u0631\u0629","invoice_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0641\u0627\u062a\u0648\u0631\u0629","issue_by":"\u0635\u062f\u0631 \u0628\u0648\u0627\u0633\u0637\u0629","issue_for":"\u0645\u0634\u0643\u0644\u0629 \u0645\u0646 \u0623\u062c\u0644","last_recurring_on":"\u0622\u062e\u0631 \u062a\u0643\u0631\u0627\u0631 \u0641\u064a","make_payment":"\u0642\u0645 \u0628\u0627\u0644\u062f\u0641\u0639","new_invoice":"\u0641\u0627\u062a\u0648\u0631\u0629 \u062c\u062f\u064a\u062f\u0629","note":"\u0645\u0644\u0627\u062d\u0638\u0629","note_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629","note_terms":"\u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0648\u0627\u0644\u0634\u0631\u0648\u0637","nothing_amount_yet":"\u0644\u0627 \u0634\u064a\u0621 \u062d\u062a\u0649 \u0627\u0644\u0622\u0646.","nothing_due_yet":"\u0644\u0627 \u0634\u064a\u0621 \u0645\u0633\u062a\u062d\u0642 \u062d\u062a\u0649 \u0627\u0644\u0622\u0646.","nothing_paid_yet":"\u0644\u0645 \u064a\u062a\u0645 \u062f\u0641\u0639 \u0623\u064a \u0634\u064a\u0621 \u062d\u062a\u0649 \u0627\u0644\u0622\u0646.","overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629","paid":"\u0645\u062f\u0641\u0648\u0639","paid_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u062f\u0641\u0648\u0639","parent_invoice":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0648\u0627\u0644\u062f","payment":"\u0627\u0644\u062f\u0641\u0639","payment_history":"\u0633\u062c\u0644 \u0627\u0644\u062f\u0641\u0639\u0627\u062a","payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","payment_reminder_mail":"\u0628\u0631\u064a\u062f \u062a\u0630\u0643\u064a\u0631 \u0627\u0644\u062f\u0641\u0639","price":"\u0627\u0644\u0633\u0639\u0631","print_invoice":"\u0637\u0628\u0627\u0639\u0629 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","qty":"\u0627\u0644\u0643\u0645\u064a\u0629","recurring":"\u0645\u062a\u0643\u0631\u0631","recurring_cycle":"\u062f\u0648\u0631\u0629 \u0645\u062a\u0643\u0631\u0631\u0629","recurring_invoices":"\u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062a\u0643\u0631\u0631\u0629","remaining_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u062a\u0628\u0642\u064a","remove_note_term":"\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0648\u0627\u0644\u0645\u0635\u0637\u0644\u062d\u0627\u062a","send":"\u0625\u0631\u0633\u0627\u0644","send_invoice":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","start_recurring":"\u0627\u0628\u062f\u0623 \u0627\u0644\u062a\u0643\u0631\u0627\u0631","stop_recurring":"\u062a\u0648\u0642\u0641 \u0639\u0646 \u0627\u0644\u062a\u0643\u0631\u0627\u0631","sub_total":"\u0627\u0644\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u0641\u0631\u0639\u064a","tax":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","terms":"\u0627\u0644\u0634\u0631\u0648\u0637","terms_not_found":"\u0627\u0644\u0645\u0635\u0637\u0644\u062d\u0627\u062a \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629","total":"\u0625\u062c\u0645\u0627\u0644\u064a","total_tax":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","transactions":"\u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a","yes_send":"\u0646\u0639\u0645 \u0627\u0631\u0633\u0644"},"invoice_templates":"\u0646\u0645\u0627\u0630\u062c \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoices":"\u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631","item":"\u063a\u0631\u0636","language":"\u0627\u0644\u0644\u063a\u0629","login":{"email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","forget_your_password":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631\u061f","login":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","remember_me":"\u062a\u0630\u0643\u0631\u0646\u0649","sign_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644"},"months":{"apr":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","sep":"\u0633\u0628\u062a\u0645\u0628\u0631"},"no_records_found":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0633\u062c\u0644\u0627\u062a.","notification":{"mark_all_as_read":"\u0648\u0636\u0639 \u0639\u0644\u0627\u0645\u0629 \u0645\u0642\u0631\u0648\u0621\u0629 \u0639\u0644\u0649 \u0627\u0644\u0643\u0644","notifications":"\u0625\u062e\u0637\u0627\u0631\u0627\u062a","you_don`t_have_any_new_notification":"\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 \u0623\u064a \u0625\u0634\u0639\u0627\u0631 \u062c\u062f\u064a\u062f"},"paid_invoices":"\u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0629","payment":{"add_payment":"\u0625\u0636\u0627\u0641\u0629 \u062f\u0641\u0639\u0629","edit_payment":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0641\u0639","payable_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642 \u0627\u0644\u062f\u0641\u0639","payment_amount":"\u0645\u0628\u0644\u063a \u0627\u0644\u062f\u0641\u0639\u0629","payment_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u062f\u0641\u0639","payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","payment_mode":"\u0648\u0636\u0639 \u0627\u0644\u062f\u0641\u0639","payment_type":"\u0646\u0648\u0639 \u0627\u0644\u062f\u0641\u0639","transaction_id":"\u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0629","transaction_notes":"\u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a"},"payment-gateway":"\u0628\u0648\u0627\u0628\u0629 \u0627\u0644\u062f\u0641\u0639","payment_qr_codes":{"action":"\u0641\u0639\u0644","add_qr":"\u0625\u0636\u0627\u0641\u0629 \u0631\u064a\u0627\u0644 \u0642\u0637\u0631\u064a","add_qr_code":"\u0625\u0636\u0627\u0641\u0629 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","default":"\u062a\u0642\u0635\u064a\u0631","edit_qr_code":"\u062a\u062d\u0631\u064a\u0631 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","payment_qr_code":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639","payment_qr_codes":"\u0631\u0645\u0648\u0632 QR \u0644\u0644\u062f\u0641\u0639","qr_code":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qr_image":"\u0635\u0648\u0631\u0629 QR","title":"\u0639\u0646\u0648\u0627\u0646"},"payments":"\u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0627\u062a","pdf_export":"\u062a\u0635\u062f\u064a\u0631 PDF","placeholder":{"invalid_country_number":"\u0631\u0642\u0645 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","select_tax":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0636\u0631\u064a\u0628\u0629","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","valid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d"},"product":{"add_product":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0646\u062a\u062c","category":"\u0627\u0644\u0641\u0626\u0629","code":"\u0631\u0645\u0632 \u0627\u0644\u0645\u0646\u062a\u062c","description":"\u0627\u0644\u0648\u0635\u0641","edit_product":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0646\u062a\u062c","image":"\u0635\u0648\u0631\u0629","name":"\u0627\u0644\u0627\u0633\u0645","price":"\u0627\u0644\u0633\u0639\u0631","product":"\u0627\u0644\u0645\u0646\u062a\u062c","product_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0646\u062a\u062c","product_name":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0646\u062a\u062c","unit_price":"\u0633\u0639\u0631 \u0627\u0644\u0648\u062d\u062f\u0629","updated_at":"\u0645\u062d\u062f\u062b \u0641\u064a"},"products":"\u0627\u0644\u0645\u0646\u062a\u062c\u0627\u062a","quote":{"add":"\u064a\u0636\u064a\u0641","add_note_term":"\u0623\u0636\u0641 \u0645\u0644\u0627\u062d\u0638\u0629 \u0648\u0634\u0631\u0648\u0637","amount":"\u0627\u0644\u0645\u0628\u0644\u063a","client":"\u0627\u0644\u0639\u0645\u064a\u0644","client_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0644\u0639\u0645\u064a\u0644","client_id_required":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0639\u0645\u064a\u0644 \u0645\u0637\u0644\u0648\u0628.","client_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0645\u064a\u0644","client_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644","convert_to_invoice":"\u0627\u0644\u062a\u062d\u0648\u064a\u0644 \u0625\u0644\u0649 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","discount":"\u0627\u0644\u062e\u0635\u0645","discount_type":"\u0646\u0648\u0639 \u0627\u0644\u062e\u0635\u0645","download":"\u062a\u0646\u0632\u064a\u0644","due_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642","due_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0633\u062a\u062d\u0642\u0627\u0642","edit_quote":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633","excel_export":"\u062a\u0635\u062f\u064a\u0631 \u0627\u0643\u0633\u0644","invoice":"\u0641\u0627\u062a\u0648\u0631\u0629","issue_by":"\u0635\u062f\u0631 \u0628\u0648\u0627\u0633\u0637\u0629","issue_for":"\u0645\u0634\u0643\u0644\u0629 \u0645\u0646 \u0623\u062c\u0644","make_payment":"\u0642\u0645 \u0628\u0627\u0644\u062f\u0641\u0639","new_quote":"\u0639\u0631\u0636 \u0623\u0633\u0639\u0627\u0631 \u062c\u062f\u064a\u062f","note":"\u0645\u0644\u0627\u062d\u0638\u0629","note_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629","note_terms":"\u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0648\u0627\u0644\u0634\u0631\u0648\u0637","overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629","paid":"\u0645\u062f\u0641\u0648\u0639","paid_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u062f\u0641\u0648\u0639","payment":"\u0627\u0644\u062f\u0641\u0639","payment_history":"\u0633\u062c\u0644 \u0627\u0644\u062f\u0641\u0639\u0627\u062a","payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","price":"\u0627\u0644\u0633\u0639\u0631","print_invoice":"\u0637\u0628\u0627\u0639\u0629 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","print_quote":"\u0637\u0628\u0627\u0639\u0629 \u0627\u0642\u062a\u0628\u0627\u0633","qty":"\u0627\u0644\u0643\u0645\u064a\u0629","quote":"\u0627\u0642\u062a\u0628\u0627\u0633","quote_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633","quote_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633","quote_id":"\u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633","quote_name":"\u064a\u0642\u062a\u0628\u0633","quote_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u0642\u062a\u0628\u0627\u0633","quote_pdf":"\u0627\u0642\u062a\u0628\u0627\u0633","quote_url":"\u0627\u0642\u062a\u0628\u0627\u0633 URL","recurring":"\u0645\u062a\u0643\u0631\u0631","remaining_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u062a\u0628\u0642\u064a","remove_note_term":"\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0648\u0627\u0644\u0645\u0635\u0637\u0644\u062d\u0627\u062a","sub_total":"\u0627\u0644\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u0641\u0631\u0639\u064a","tax":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","terms":"\u0627\u0644\u0634\u0631\u0648\u0637","terms_not_found":"\u0627\u0644\u0645\u0635\u0637\u0644\u062d\u0627\u062a \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629","total":"\u0625\u062c\u0645\u0627\u0644\u064a","total_tax":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","transactions":"\u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a"},"quotes":"\u064a\u0642\u062a\u0628\u0633","received_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0630\u064a \u062a\u0633\u0644\u0645\u0647","registered_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u062a\u0633\u062c\u064a\u0644","roles":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631","setting":{"address":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646","app_logo":"\u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","app_name":"\u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","auto_approve":"\u0627\u0639\u062a\u0645\u0627\u062f \u062a\u0644\u0642\u0627\u0626\u064a","clinic_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u064a\u0627\u062f\u0629","color":"\u0627\u0644\u0644\u0648\u0646","company_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0634\u0631\u0643\u0629","company_image_validation":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 210 \u00d7 50 \u0628\u0643\u0633\u0644.","company_logo":"\u0634\u0639\u0627\u0631 \u0627\u0644\u0634\u0631\u0643\u0629","company_name":"\u0627\u0633\u0645 \u0627\u0644\u0634\u0631\u0643\u0629","company_phone":"\u0647\u0627\u062a\u0641 \u0627\u0644\u0634\u0631\u0643\u0629","contact_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644","country_code":"\u0643\u0648\u062f \u0627\u0644\u062f\u0648\u0644\u0629","currencies":"\u0627\u0644\u0639\u0645\u0644\u0627\u062a","currency_position":"\u0648\u0636\u0639 \u0627\u0644\u0639\u0645\u0644\u0629","currency_settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0639\u0645\u0644\u0629","date_format":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u062a\u0627\u0631\u064a\u062e","decimal_separator":"\u0627\u0644\u0641\u0627\u0635\u0644 \u0627\u0644\u0639\u0634\u0631\u064a","fav_icon":"\u0641\u0627\u0641\u064a\u0643\u0648\u0646","general":"\u0639\u0627\u0645","general_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0639\u0627\u0645\u0629","image_validation":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 90 \u00d7 60 \u0628\u0643\u0633\u0644.","invoice_no_prefix":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0644\u0627 \u0628\u0627\u062f\u0626\u0629","invoice_no_suffix":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0644\u0627 \u0644\u0627\u062d\u0642\u0629","invoice_settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","invoice_template":"\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","mail_notifications":"\u0625\u062e\u0637\u0627\u0631\u0627\u062a \u0627\u0644\u0628\u0631\u064a\u062f","manual_payment_approval":"\u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","payment_approved":"\u062a\u0645\u062a \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u0641\u0639","payment_auto_approved":"\u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0627\u0644\u062a\u0644\u0642\u0627\u0626\u064a\u0629 \u0639\u0644\u0649 \u0627\u0644\u062f\u0641\u0639","paypal":"\u0628\u0627\u064a \u0628\u0627\u0644","paypal_client_id":"\u0645\u0639\u0631\u0641 \u0639\u0645\u064a\u0644 Paypal","paypal_secret":"\u0633\u0631 \u0628\u0627\u064a \u0628\u0627\u0644","postal_code":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a","prefix":"\u0628\u0627\u062f\u0626\u0629","razorpay":"\u0631\u0627\u0632\u0648\u0631\u0628\u064a","razorpay_key":"\u0645\u0641\u062a\u0627\u062d Razorpay","razorpay_secret":"\u0633\u0631 Razorpay","send_due_invoice_email_before_x_days":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0628\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0627\u0644\u0645\u0633\u062a\u062d\u0642 \u0642\u0628\u0644 X \u0645\u0646 \u0627\u0644\u0623\u064a\u0627\u0645","setting":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f","show_additional_address":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u064a \u0641\u064a \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","show_currency_behind":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0645\u0644\u0629 \u0641\u064a \u0627\u0644\u062e\u0644\u0641","show_product_description":"\u0639\u0631\u0636 \u0648\u0635\u0641 \u0627\u0644\u0645\u0646\u062a\u062c","specialities":"\u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","stripe":"\u0634\u0631\u064a\u0637","stripe_key":"\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0634\u0631\u064a\u0637","stripe_secret":"\u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637","thousand_separator":"\u0641\u0627\u0635\u0644 \u0627\u0644\u0623\u0644\u0641","time_format":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0648\u0642\u062a","timezone":"\u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629"},"settings":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a","sign_out":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062e\u0631\u0648\u062c","states":"\u0627\u0644\u062f\u0648\u0644","tax":{"add_tax":"\u0625\u0636\u0627\u0641\u0629 \u0636\u0631\u064a\u0628\u0629","edit_tax":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0636\u0631\u0627\u0626\u0628","is_default":"\u0627\u0641\u062a\u0631\u0627\u0636\u064a","no":"\u0644\u0627","tax":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","yes":"\u0646\u0639\u0645"},"tax_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u062d\u0648\u0644 \u0627\u0644\u0636\u0631\u0627\u0626\u0628","taxes":"\u0627\u0644\u0636\u0631\u0627\u0626\u0628","transactions":"\u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a","unpaid_invoices":"\u0641\u0648\u0627\u062a\u064a\u0631 \u063a\u064a\u0631 \u0645\u062f\u0641\u0648\u0639\u0629","user":{"account":"\u062d\u0633\u0627\u0628","account_setting":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u062d\u0633\u0627\u0628","avatar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","change_password":"\u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","gender":"\u0627\u0644\u0646\u0648\u0639","new_password":"\u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062c\u062f\u064a\u062f\u0629","phone":"\u0647\u0627\u062a\u0641","phone_number":"\u0631\u0642\u0645 \u0627\u0644\u062a\u0644\u064a\u0641\u0648\u0646","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","profile_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","save_changes":"\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","setting":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f","user_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"users":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646","weekdays":{"fri":"\u0627\u0644\u0627\u0628","mon":"\u0645","sat":"\u0633","sun":"\u0633","thu":"\u062a\u064a","tue":"\u062a\u064a","wed":"\u062f\u0628\u0644\u064a\u0648"}},"de.messages":{"add_admin":"Administrator hinzuf\u00fcgen","admin":"Administrator","admin_dashboard":{"dashboard":"Armaturenbrett","day":"Tag","income_overview":"Einkommens\u00fcbersicht","invoice_overview":"Rechnungs\u00fcbersicht","month":"Monat","monthly_income_overview":"\u00dcbersicht \u00fcber das monatliche Einkommen","name":"NAME","no_record_found":"Kein Datensatz gefunden","payment_overview":"Zahlungs\u00fcbersicht","registered":"EINGETRAGEN","total_amount":"Gesamtbetrag","total_clients":"Gesamtkunden","total_due":"Gesamt f\u00e4llig","total_invoices":"Rechnungen insgesamt","total_overdue_invoice":"Gesamt \u00fcberf\u00e4llige Rechnungen","total_paid":"Gesamt bezahlt","total_paid_invoices":"Bezahlte Rechnungen insgesamt","total_partial_paid_invoices":"Teilweise bezahlte Rechnungen insgesamt","total_payments":"Zahlungen insgesamt","total_products":"Gesamtprodukte","total_unpaid_invoices":"Unbezahlte Rechnungen insgesamt","week":"Woche","year":"Jahr","yearly_income_overview":"J\u00e4hrliche Einkommens\u00fcbersicht"},"admin_details":"Admin-Details","admins":"Administratoren","apps":"Apps","categories":"Kategorien","category":{"add_category":"Kategorie hinzuf\u00fcgen","category":"Kategorie","edit_category":"Kategorie bearbeiten"},"change_avatar":"Avatar \u00e4ndern","change_language":"Sprache \u00e4ndern","cities":"St\u00e4dte","clear_cache":"Cache leeren","client":{"add_client":"Client hinzuf\u00fcgen","add_user":"Benutzer hinzuf\u00fcgen","address":"Adresse","city":"Stadt","client":"Kunde","client_details":"Kundendetails","confirm_password":"Passwort best\u00e4tigen","contact_no":"Kontakt-Nr","country":"Land","created_at":"Datum","edit_user":"Benutzer bearbeiten","email":"E-Mail","female":"weiblich","first_name":"Vorname","gender":"Geschlecht","last_name":"Nachname","male":"m\u00e4nnlich","note":"Anmerkung","notes":"Notizen","password":"Passwort","postal_code":"Postleitzahl","profile":"Profil","role":"Rolle","state":"Staat","website":"Website"},"client_address":"Kundenadresse","clients":"Kunden","common":{"action":"Aktion","actions":"Aktionen","active":"Aktiv","add":"Hinzuf\u00fcgen","address":"Adresse","allow_file_type":"Erlaubte Dateitypen","apply":"Sich bewerben","are_you_sure_delete":"M\u00f6chten Sie dies wirklich l\u00f6schen?","attachment":"Anhang","back":"zur\u00fcck","cancel":"Abbrechen","city":"Stadt","click_here":"Klicken Sie hier","country":"Land","created_at":"Erstellt","custom":"Brauch","de_active":"Deaktiviert","default":"Standard","delete":"l\u00f6schen","deleted":"es wurde gel\u00f6scht!","details":"Einzelheiten","discard":"verwerfen","edit":"Bearbeiten","email":"Email","error":"Fehler","filter":"Filtern","filter_options":"Filteroptionen","from":"Aus","has_been_deleted":"wurde gel\u00f6scht.","invoice":"RECHNUNG","last_update":"Letztes Aktualisieren","mo":"Mo","n\/a":"N\/A","name":"Name","no_cancel":"Nein, Abbrechen","ok":"OK","pay":"bezahlen","payment_type":"Zahlungsart","please_wait":"Bitte warten...","regards":"Gr\u00fc\u00dfe","reminder":"Erinnerung","reset":"Zur\u00fccksetzen","save":"Speichern","save_draft":"Als Entwurf speichern","save_send":"Speichern & senden","search":"Suche","service":"Service","state":"Staat","status":"Status","submit":"senden","to":"Zu","updated_at":"Aktualisiert","value":"Wert","yes_delete":"Ja, l\u00f6schen!","zipcode":"PLZ"},"countries":"L\u00e4nder","currency":{"add_currency":"W\u00e4hrung hinzuf\u00fcgen","currency":"W\u00e4hrung","currency_code":"W\u00e4hrungscode","edit_currency":"W\u00e4hrung bearbeiten","icon":"Symbol"},"currency_reports":"W\u00e4hrungsberichte","dashboard":"Armaturenbrett","datepicker":{"custom":"Benutzerdefinierten Bereich","last_30_days":"Letzte 30 Tage","last_7_days":"Letzten 7 Tage","last_month":"Im vergangenen Monat","last_week":"Letzte Woche","this_month":"Diesen Monat","this_week":"In dieser Woche","today":"Heute","yesterday":"Gestern"},"edit_admin":"Administrator bearbeiten","flash":{"Admin_cant_be_deleted":"Administrator kann nicht gel\u00f6scht werden","Admin_deleted_successfully":"Administrator erfolgreich gel\u00f6scht","Invoice_send_successfully":"Rechnung erfolgreich versendet","admin_created_successfully":"Administrator erfolgreich erstellt","admin_profile_updated_successfully":"Administratorprofil erfolgreich aktualisiert","admin_updated_successfully":"Admin erfolgreich aktualisiert","all_notification_read_successfully":"Alle Benachrichtigungen erfolgreich gelesen","allowed_file_types_png_jpg_jpeg":"Zul\u00e4ssige Dateitypen: PNG, JPG, JPEG.","application_cache_cleared":"Anwendungscache geleert!","are_sure_want_to_delete_this_client_related_all_invoices":"M\u00f6chten Sie wirklich alle Rechnungen f\u00fcr diesen Kunden l\u00f6schen?","category_cant_deleted":"Kategorie kann nicht gel\u00f6scht werden.","category_deleted_successfully":"Kategorie erfolgreich gel\u00f6scht","category_retrieved_successfully":"Kategorie erfolgreich abgerufen","category_saved_successfully":"Kategorie erfolgreich gespeichert","category_updated_successfully":"Kategorie erfolgreich aktualisiert","cities_retrieved_successfully":"St\u00e4dte erfolgreich abgerufen","click_refresh_icon_generate_product_code":"Klicken Sie auf das Aktualisierungssymbol, um den Produktcode zu generieren","client_cant_deleted":"Client kann nicht gel\u00f6scht werden.","client_created_successfully":"Client erfolgreich erstellt","client_deleted_successfully":"Client erfolgreich gel\u00f6scht","client_updated_successfully":"Client erfolgreich aktualisiert","converted_quote_can_not_editable":"Konvertiertes Angebot kann nicht bearbeitet werden","converted_to_invoice_successfully":"Erfolgreich in Rechnung konvertiert","currency_cant_deleted":"Diese W\u00e4hrung wird woanders verwendet.","currency_deleted_successfully":"W\u00e4hrung erfolgreich gel\u00f6scht","currency_saved_successfully":"W\u00e4hrung erfolgreich gespeichert.","currency_updated_successfully":"W\u00e4hrung erfolgreich aktualisiert","current_password_is_invalid":"Aktuelles Passwort ist ung\u00fcltig","default_admin_can_not_editable":"Standardadministrator kann nicht bearbeitet werden","invoice_currency_retrieved_successfully":"Rechnungsw\u00e4hrung erfolgreich abgerufen","invoice_deleted_successfully":"Rechnung erfolgreich gel\u00f6scht","invoice_due_amount_retrieve_successfully":"F\u00e4lliger Rechnungsbetrag erfolgreich abgerufen","invoice_saved_and_sent_successfully":"Rechnung erfolgreich gespeichert und versendet","invoice_saved_successfully":"Rechnung erfolgreich gespeichert","invoice_template_updated_successfully":"Rechnungsvorlage erfolgreich aktualisiert","invoice_updated_and_send_successfully":"Rechnung aktualisiert und erfolgreich versendet","invoice_updated_successfully":"Rechnung erfolgreich aktualisiert","language_updated_successfully":"Sprache erfolgreich aktualisiert","manual_payment_approved_successfully":"Manuelle Zahlung erfolgreich genehmigt","manual_payment_denied_successfully":"Manuelle Zahlung erfolgreich abgelehnt","note_retrieved_successfully":"Notiz erfolgreich abgerufen","notification_read_successfully":"Benachrichtigung erfolgreich gelesen","number_of_days_for_recurring_cycle":"Anzahl der Tage f\u00fcr wiederkehrenden Zyklus","password_updated_successfully":"Passwort erfolgreich aktualisiert","payment_deleted_successfully":"Zahlung erfolgreich gel\u00f6scht.","payment_overview_status_retrieved_successfully":"PaymentOverview-Status erfolgreich abgerufen","payment_qr_code_deleted_successfully":"Zahlungs-QR-Code erfolgreich gel\u00f6scht","payment_qr_code_saved_successfully":"Zahlungs-QR-Code erfolgreich gespeichert","payment_qr_code_status_updated_successfully":"Status des Zahlungs-QR-Codes erfolgreich aktualisiert","payment_qr_code_updated_successfully":"Zahlungs-QR-Code erfolgreich aktualisiert","payment_reminder_mail_send_successfully":"Zahlungserinnerungsmail erfolgreich versendet","payment_saved_successfully":"Zahlung erfolgreich gespeichert.","payment_updated_successfully":"Zahlung erfolgreich aktualisiert.","product_cant_deleted":"Produkt kann nicht gel\u00f6scht werden.","product_created_successfully":"Produkt erfolgreich erstellt","product_deleted_successfully":"Produkt erfolgreich gel\u00f6scht","product_price_retrieved_successfully":"Produktpreis erfolgreich abgerufen","product_updated_successfully":"Produkt erfolgreich aktualisiert","quote_deleted_successfully":"Angebot erfolgreich gel\u00f6scht","quote_saved_successfully":"Angebot erfolgreich gespeichert","quote_updated_successfully":"Angebot erfolgreich aktualisiert","recurring_status_updated_successfully":"Wiederkehrender Status erfolgreich aktualisiert","seems_you_are_not_allowed_to_access_this_record":"Anscheinend sind Sie nicht berechtigt, auf diesen Datensatz zuzugreifen.","select_currency":"W\u00e4hrung w\u00e4hlen","select_payment_qr_code":"Zahlungs-QR-Code ausw\u00e4hlen","select_product_or_enter_free_text":"Produkt ausw\u00e4hlen oder Freitext eingeben","setting_updated_successfully":"Einstellung erfolgreich aktualisiert","status_retrieved_successfully":"Status erfolgreich abgerufen","status_updated_successfully":"Status erfolgreich aktualisiert","tax_can_not_deleted":"Steuer kann nicht gel\u00f6scht werden.","tax_deleted_successfully":"Steuer erfolgreich gel\u00f6scht","tax_retrieved_successfully":"Steuer erfolgreich abgerufen","tax_saved_successfully":"Steuer erfolgreich gespeichert","tax_updated_successfully":"Steuer erfolgreich aktualisiert","yearly_income_overview_chart_data_retrieved_successfully":"Daten des Jahreseinkommens\u00fcbersichtsdiagramms erfolgreich abgerufen"},"general":"allgemein","invoice":{"add":"Hinzuf\u00fcgen","add_note_term":"Notiz & Begriffe hinzuf\u00fcgen","amount":"Betrag","amount_should_be_less_than_payable_amount":"Der Betrag sollte geringer sein als der zu zahlende Betrag.","are_you_sure_send":"M\u00f6chten Sie diese Rechnung wirklich an den Kunden senden?","client":"Kunde","client_email":"Kunden-E-Mail","client_name":"Kundenname","client_overview":"KUNDEN\u00dcBERSICHT","copy_invoice_url":"Rechnungs-URL kopieren","discount":"Rabatt","discount_type":"Rabatttyp","download":"Herunterladen","due_amount":"F\u00e4lliger Betrag","due_date":"F\u00e4lligkeitsdatum","edit_invoice":"Rechnung bearbeiten","excel_export":"Excel-Export","fax_no":"Faxnummer","has_been_sent":"wurde gesendet.","invoice":"Rechnung","invoice_date":"Rechnungsdatum","invoice_details":"Rechnungs Einzelheiten","invoice_id":"Rechnungs-ID","invoice_number":"Rechnungsnummer","invoice_pdf":"Rechnung","invoice_url":"Rechnungs-URL","issue_by":"Ausgestellt von","issue_for":"Ausgabe f\u00fcr","last_recurring_on":"Letzte wiederkehrende Ein","make_payment":"Zahlung leisten","new_invoice":"Neue Rechnung","note":"Anmerkung","note_not_found":"Notiz nicht gefunden","note_terms":"Hinweis & Bedingungen","nothing_amount_yet":"Noch kein Betrag.","nothing_due_yet":"Noch ist nichts f\u00e4llig.","nothing_paid_yet":"Noch nichts bezahlt.","overview":"\u00dcbersicht","paid":"bezahlt","paid_amount":"Bezahlter Betrag","parent_invoice":"Elternrechnung","payment":"Zahlung","payment_history":"Zahlungsverlauf","payment_method":"Zahlungsmethode","payment_reminder_mail":"Zahlungserinnerungsmail","price":"Preis","print_invoice":"Rechnung drucken","qty":"Menge","recurring":"wiederkehrend","recurring_cycle":"Wiederkehrender Zyklus","recurring_invoices":"Wiederkehrende Rechnungen","remaining_amount":"Restbetrag","remove_note_term":"Notiz & Begriffe entfernen","send":"Senden","send_invoice":"Rechnung senden","start_recurring":"wiederkehrend beginnen","stop_recurring":"h\u00f6r auf zu wiederholen","sub_total":"Zwischensumme","tax":"Steuer","terms":"Begriffe","terms_not_found":"Begriffe nicht gefunden","total":"Gesamt","total_tax":"Steuer","transactions":"Transaktionen","yes_send":"Ja, senden"},"invoice_templates":"Rechnungsvorlagen","invoices":"Rechnungen","item":"Artikel","language":"Sprache","login":{"email":"Email","forget_your_password":"Haben Sie Ihr Passwort vergessen?","login":"Anmeldung","password":"Passwort","remember_me":"Mich erinnern","sign_in":"Sign In"},"months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Juli","jun":"Jun","mar":"Besch\u00e4digen","may":"Kann","nov":"Nov","oct":"Okt","sep":"Sep"},"no_records_found":"Keine Aufzeichnungen gefunden.","notification":{"mark_all_as_read":"Alle als gelesen markieren","notifications":"Benachrichtigungen","you_don`t_have_any_new_notification":"Sie haben keine neue Benachrichtigung"},"paid_invoices":"Bezahlte Rechnungen","payment":{"add_payment":"Zahlung hinzuf\u00fcgen","edit_payment":"Zahlung bearbeiten","payable_amount":"Zahlbarer Betrag","payment_amount":"Zahlungsbetrag","payment_date":"Zahlungsdatum","payment_method":"Zahlungsmethode","payment_mode":"Zahlungsmodus","payment_type":"Zahlungsart","transaction_id":"Transaktions-ID","transaction_notes":"Transaktionsnotizen"},"payment-gateway":"Zahlungs-Gateways","payment_qr_codes":{"action":"Aktion","add_qr":"Qr hinzuf\u00fcgen","add_qr_code":"QR-Code hinzuf\u00fcgen","default":"Standard","edit_qr_code":"QR-Code bearbeiten","payment_qr_code":"Zahlungs-QR-Code","payment_qr_codes":"Zahlungs-QR-Codes","qr_code":"QR-Code","qr_image":"QR-Bild","title":"Titel"},"payments":"Zahlungen","pdf_export":"PDF-Export","placeholder":{"invalid_country_number":"Ung\u00fcltige L\u00e4ndernummer","invalid_number":"Ung\u00fcltige Nummer","select_tax":"Steuer ausw\u00e4hlen","too_long":"Zu lang","too_short":"Zu kurz","valid_number":"G\u00fcltige Nummer"},"product":{"add_product":"Produkt hinzuf\u00fcgen","category":"Kategorie","code":"Produktcode","description":"Beschreibung","edit_product":"Produkt bearbeiten","image":"Bild","name":"Name","price":"Preis","product":"Produkt","product_details":"Produkt Einzelheiten","product_name":"Produktname","unit_price":"Einheitspreis","updated_at":"Aktualisiert um"},"products":"Produkte","quote":{"add":"Hinzuf\u00fcgen","add_note_term":"Notiz & Begriffe hinzuf\u00fcgen","amount":"Betrag","client":"Kunde","client_email":"Kunden-E-Mail","client_id_required":"Die Client-ID ist erforderlich.","client_name":"Kundenname","client_overview":"KUNDEN\u00dcBERSICHT","convert_to_invoice":"In Rechnung umwandeln","discount":"Rabatt","discount_type":"Rabatttyp","download":"Herunterladen","due_amount":"F\u00e4lliger Betrag","due_date":"F\u00e4lligkeitsdatum","edit_quote":"Zitat bearbeiten","excel_export":"Excel-Export","issue_by":"Ausgestellt von","issue_for":"Ausgabe f\u00fcr","make_payment":"Zahlung leisten","new_quote":"Neues Zitat","note":"Anmerkung","note_not_found":"Notiz nicht gefunden","note_terms":"Hinweis & Bedingungen","overview":"\u00dcbersicht","paid":"bezahlt","paid_amount":"Bezahlter Betrag","payment":"Zahlung","payment_history":"Zahlungsverlauf","payment_method":"Zahlungsmethode","price":"Preis","print_invoice":"Rechnung drucken","print_quote":"Angebot drucken","qty":"Menge","quote":"Zitat","quote_date":"Angebotsdatum","quote_details":"Angebotsdetails","quote_id":"Zitat-ID","quote_name":"Zitieren","quote_number":"Angebotsnummer","quote_pdf":"Zitat","quote_url":"Zitat-URL","recurring":"wiederkehrend","remaining_amount":"Restbetrag","remove_note_term":"Notiz & Begriffe entfernen","sub_total":"Zwischensumme","tax":"Steuer","terms":"Begriffe","terms_not_found":"Begriffe nicht gefunden","total":"Gesamt","total_tax":"Steuer","transactions":"Transaktionen"},"quotes":"Zitate","received_amount":"Erhaltener Betrag","registered_date":"Eingetragenes Datum","roles":"Rollen","setting":{"address":"Adresse","app_logo":"App-Logo","app_name":"App-Name","auto_approve":"Automatisch genehmigen","color":"Farbe","company_address":"Firmenadresse","company_image_validation":"Das Bild muss eine Pixelgr\u00f6\u00dfe von 210 x 50 haben.","company_logo":"Firmenlogo","company_name":"Firmenname","company_phone":"Firmentelefon","contact_information":"Kontaktinformationen","country_code":"L\u00e4ndercode","currencies":"W\u00e4hrungen","currency_position":"W\u00e4hrungsposition","currency_settings":"W\u00e4hrungseinstellungen","date_format":"Datumsformat","decimal_separator":"Dezimaltrennzeichen","fav_icon":"Favicon","general":"allgemein","general_details":"Allgemeine Einzelheiten","image_validation":"Das Bild muss Pixel 90 x 60 haben.","invoice_no_prefix":"Rechnung ohne Pr\u00e4fix","invoice_no_suffix":"Rechnung ohne Suffix","invoice_settings":"Rechnungseinstellungen","invoice_template":"Rechnungsvorlage","mail_notifications":"E-Mail-Benachrichtigungen","manual_payment_approval":"Manuelle Zahlungsgenehmigung","payment_approved":"Zahlung genehmigt","payment_auto_approved":"Automatische Zahlungsgenehmigung","paypal":"PayPal","paypal_client_id":"Paypal-Kunden-ID","paypal_secret":"Paypal-Geheimnis","postal_code":"Postleitzahl","prefix":"Pr\u00e4fix","razorpay":"Razorpay","razorpay_key":"Razorpay-Schl\u00fcssel","razorpay_secret":"Razorpay-Geheimnis","send_due_invoice_email_before_x_days":"Senden Sie die E-Mail mit der f\u00e4lligen Rechnung vor X Tagen","setting":"Einstellung","show_additional_address":"Zus\u00e4tzliche Adresse in der Rechnung angeben","show_currency_behind":"W\u00e4hrung dahinter anzeigen","show_product_description":"Produktbeschreibung anzeigen","stripe":"Streifen","stripe_key":"Stripe-Schl\u00fcssel","stripe_secret":"Stripe-Geheimnis","thousand_separator":"Tausend-Trennzeichen","time_format":"Zeitformat","timezone":"Zeitzone"},"settings":"Einstellungen","sign_out":"Abmelden","states":"Staaten","tax":{"add_tax":"Steuer hinzuf\u00fcgen","edit_tax":"Steuer bearbeiten","is_default":"Ist Standard","no":"Nein","tax":"Steuer","yes":"ja"},"tax_information":"Steuerinformation","taxes":"Steuern","transactions":"Transaktionen","unpaid_invoices":"Unbezahlte Rechnungen","user":{"account":"Konto","account_setting":"Kontoeinstellungen","avatar":"Benutzerbild","change_password":"Passwort \u00e4ndern","confirm_password":"Passwort best\u00e4tigen","contact_number":"Kontaktnummer","current_password":"Aktuelles Passwort","email":"E-Mail","full_name":"Vollst\u00e4ndiger Name","gender":"Geschlecht","new_password":"Neues Passwort","phone":"Telefon","phone_number":"Telefonnummer","profile":"Profil","profile_details":"Profil Einzelheiten","save_changes":"\u00c4nderungen speichern","setting":"Einstellung","user_details":"Benutzerdetails"},"users":"Benutzer","weekdays":{"fri":"FR","mon":"MO","sat":"Sa","sun":"SONNE","thu":"DO","tue":"DI","wed":"HEIRATEN"}},"en.messages":{"add_admin":"Add Admin","admin":"Admin","admin_dashboard":{"dashboard":"Dashboard","day":"Day","income_overview":"Income Overview","invoice_overview":"Invoices Overview","month":"Month","monthly_income_overview":"Monthly Income Overview","name":"NAME","no_record_found":"No Record Found","payment_overview":"Payment Overview","registered":"REGISTERED","total_amount":"Total Amount","total_clients":"Total Clients","total_due":"Total Due","total_invoices":"Total Invoices","total_overdue_invoice":"Total Overdue Invoices","total_paid":"Total Paid","total_paid_invoices":"Total Paid Invoices","total_partial_paid_invoices":"Total Partially Paid Invoices","total_payments":"Total Payments","total_products":"Total Products","total_unpaid_invoices":"Total Unpaid Invoices","week":"Week","year":"Year","yearly_income_overview":"Yearly Income Overview"},"admin_details":"Admin Details","admins":"Admins","apps":"Apps","categories":"Categories","category":{"add_category":"Add Category","category":"Category","edit_category":"Edit Category"},"change_avatar":"Change avatar","change_language":"Change Language","cities":"Cities","clear_cache":"Clear Cache","client":{"add_client":"Add Client","add_user":"Add User","address":"Address","city":"City","client":"Client","client_details":"Client Details","confirm_password":"Confirm Password","contact_no":"Contact No","country":"Country","created_at":"Date","edit_user":"Edit User","email":"Email","female":"Female","first_name":"First Name","gender":"Gender","last_name":"Last Name","male":"Male","note":"Note","notes":"Notes","password":"Password","postal_code":"Postal Code","profile":"Profile","role":"Role","state":"State","website":"Website"},"client_address":"Client Address","clients":"Clients","common":{"action":"Action","actions":"Actions","active":"Active","add":"Add","address":"Address","allow_file_type":"Allowed file types","apply":"Apply","are_you_sure_delete":"Are you sure want to delete this","attachment":"Attachment","back":"Back","cancel":"Cancel","city":"City","click_here":"Click Here","country":"Country","created_at":"Created","custom":"Custom","de_active":"Deactive","default":"Default","delete":"Delete","deleted":"Deleted!","details":"Details","discard":"Discard","edit":"Edit","email":"Email","error":"Error","filter":"Filter","filter_option":"Filter Option","filter_options":"Filter Options","from":"From","has_been_deleted":"has been deleted.","invoice":"INVOICE","last_update":"Last Update","mo":"Mo","n\/a":"N\/A","name":"Name","no_cancel":"No, Cancel","ok":"Ok","pay":"Pay","payment_type":"Payment Type","please_wait":"Please wait...","regards":"Regards","reminder":"Reminder","reset":"Reset","save":"Save","save_draft":"Save As Draft","save_send":"Save & Send","search":"Search","service":"Service","state":"State","status":"Status","submit":"Submit","this_week":"The Week","to":"To","updated_at":"Updated","value":"Value","yes_delete":"Yes, Delete!","zipcode":"Zip Code"},"countries":"Countries","currency":{"add_currency":"Add Currency","add_currency_code_as_per_three_letter_iso_code":"Add currency code as per three-letter ISO code","currency":"Currency","currency_code":"Currency Code","edit_currency":"Edit Currency","icon":"Icon","note":"Note","you_can_find_out_here":"you can find out here"},"currency_reports":"Currency Reports","dashboard":"Dashboard","datepicker":{"custom":"Custom Range","last_30_days":"Last 30 Days","last_7_days":"Last 7 Days","last_month":"Last Month","last_week":"Last Week","this_month":"This Month","this_week":"This Week","today":"Today","yesterday":"Yesterday"},"edit_admin":"Edit Admin","flash":{"Admin_cant_be_deleted":"Admin can't be deleted","Admin_deleted_successfully":"Admin deleted successfully","Invoice_send_successfully":"Invoice send successfully","admin_created_successfully":"Admin created successfully","admin_profile_updated_successfully":"Admin profile updated successfully","admin_updated_successfully":"Admin updated successfully","all_notification_read_successfully":"All notification read successfully","allowed_file_types_png_jpg_jpeg":"Allowed file types: png, jpg, jpeg.","application_cache_cleared":"Application cache cleared!","are_sure_want_to_delete_this_client_related_all_invoices":"Are you sure want to delete this client related all invoices ?","category_cant_deleted":"Category can't be deleted.","category_deleted_successfully":"Category deleted successfully","category_retrieved_successfully":"Category retrieved successfully","category_saved_successfully":"Category saved successfully","category_updated_successfully":"Category updated successfully","cities_retrieved_successfully":"Cities retrieved successfully","click_refresh_icon_generate_product_code":"Click refresh icon to generate product code.","client_cant_deleted":"Client can't be deleted.","client_created_successfully":"Client created successfully","client_deleted_successfully":"Client deleted successfully","client_updated_successfully":"Client updated successfully","converted_quote_can_not_editable":"Converted quote can not be editable","converted_to_invoice_successfully":"Converted to invoice successfully","currency_cant_deleted":"This Currency is used somewhere else.","currency_deleted_successfully":"Currency deleted successfully","currency_saved_successfully":"Currency saved successfully.","currency_updated_successfully":"Currency updated successfully","current_password_is_invalid":"Current password is invalid","default_admin_can_not_editable":"Default admin can not editable","invoice_currency_retrieved_successfully":"Invoice currency retrieved successfully","invoice_deleted_successfully":"Invoice deleted successfully","invoice_due_amount_retrieve_successfully":"Invoice due amount retrieved successfully","invoice_saved_and_sent_successfully":"Invoice saved & sent successfully","invoice_saved_successfully":"Invoice saved successfully","invoice_template_updated_successfully":"Invoice template updated successfully","invoice_updated_and_send_successfully":"Invoice updated & sent successfully","invoice_updated_successfully":"Invoice updated successfully","language_updated_successfully":"Language updated successfully","manual_payment_approved_successfully":"Manual payment approved successfully","manual_payment_denied_successfully":"Manual payment denied successfully","note_retrieved_successfully":"Note retrieved successfully","notification_read_successfully":"Notification read successfully","number_of_days_for_recurring_cycle":"Number of Days For Recurring Cycle","password_updated_successfully":"Password updated successfully","payment_deleted_successfully":"Payment deleted successfully.","payment_overview_status_retrieved_successfully":"PaymentOverview status retrieved successfully","payment_qr_code_deleted_successfully":"Payment qr code deleted successfully","payment_qr_code_saved_successfully":"Payment qr code saved successfully","payment_qr_code_status_updated_successfully":"Payment qr code status updated successfully","payment_qr_code_updated_successfully":"Payment qr code updated successfully","payment_reminder_mail_send_successfully":"Payment reminder mail sent successfully","payment_saved_successfully":"Payment saved successfully.","payment_updated_successfully":"Payment updated successfully.","product_cant_deleted":"Product can't be deleted.","product_created_successfully":"Product created successfully","product_deleted_successfully":"Product deleted successfully","product_price_retrieved_successfully":"Product price retrieved successfully","product_updated_successfully":"Product updated successfully","quote_deleted_successfully":"Quote deleted successfully","quote_saved_successfully":"Quote saved successfully","quote_updated_successfully":"Quote updated successfully","recurring_status_updated_successfully":"Recurring status updated successfully","seems_you_are_not_allowed_to_access_this_record":"Seems, you are not allowed to access this record.","select_currency":"Select Currency","select_payment_qr_code":"Select Payment QR Code","select_product_or_enter_free_text":"Select Product or Enter free text","setting_updated_successfully":"Setting updated successfully","status_retrieved_successfully":"Status retrieved successfully","status_updated_successfully":"Status updated successfully","tax_can_not_deleted":"Tax can't be deleted.","tax_deleted_successfully":"Tax deleted successfully","tax_retrieved_successfully":"Tax retrieved successfully","tax_saved_successfully":"Tax saved successfully","tax_updated_successfully":"Tax updated successfully","yearly_income_overview_chart_data_retrieved_successfully":"Yearly income overview chart data retrieved successfully"},"general":"General","invoice":{"add":"Add","add_note_term":"Add Note & Terms","amount":"Amount","amount_should_be_less_than_payable_amount":"Amount should be less than payable amount.","are_you_sure_send":"Are you sure want to send this invoice to client ?","client":"Client","client_email":"Client Email","client_name":"Client Name","client_overview":"CLIENT OVERVIEW","copy_invoice_url":"Copy Invoice URL","discount":"Discount","discount_type":"Discount Type","download":"Download","due_amount":"Due Amount","due_date":"Due Date","edit_invoice":"Edit Invoice","excel_export":"Excel Export","fax_no":"Fax Number","has_been_sent":"has been sent.","invoice":"Invoice","invoice_date":"Invoice Date","invoice_details":"Invoice Details","invoice_id":"Invoice ID","invoice_number":"Invoice Number","invoice_pdf":"Invoice","invoice_url":"Invoice URL","issue_by":"Issued By","issue_for":"Issue For","last_recurring_on":"Last Recurring On","make_payment":"Make Payment","new_invoice":"New Invoice","note":"Note","note_not_found":"Note Not Found","note_terms":"Note & Terms","nothing_amount_yet":"Nothing amount yet.","nothing_due_yet":"Nothing due yet.","nothing_paid_yet":"Nothing paid yet.","overview":"Overview","paid":"Paid","paid_amount":"Paid Amount","parent_invoice":"Parent Invoice","payment":"Payment","payment_history":"Payment History","payment_method":"Payment Method","payment_reminder_mail":"Payment Reminder Mail","price":"Price","print_invoice":"Print Invoice","qty":"Qty","recurring":"Recurring","recurring_cycle":"Recurring Cycle","recurring_invoices":"Recurring Invoices","remaining_amount":"Remaining Amount","remove_note_term":"Remove Note & Terms","send":"Send","send_invoice":"Send Invoice","start_recurring":"Start Recurring","stop_recurring":"Stop Recurring","sub_total":"Sub Total","tax":"Tax","terms":"Terms","terms_not_found":"Terms Not Found","total":"Total","total_tax":"Tax","transactions":"Transactions","yes_send":"Yes, Send"},"invoice_templates":"Invoice Templates","invoices":"Invoices","item":"Item","language":"Language","login":{"email":"Email","forget_your_password":"Forgot your password?","login":"Login","password":"Password","remember_me":"Remember me","sign_in":"Sign In"},"months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"no_records_found":"No records found.","notification":{"mark_all_as_read":"Mark All As Read","notifications":"Notifications","you_don`t_have_any_new_notification":"You don't have any new notification"},"paid_invoices":"Paid Invoices","payment":{"add_payment":"Add Payment","edit_payment":"Edit Payment","payable_amount":"Payable Amount","payment_amount":"Payment Amount","payment_date":"Payment Date","payment_method":"Payment Method","payment_mode":"Payment Mode","payment_type":"Payment Type","transaction_id":"Transaction Id","transaction_notes":"Transaction Notes"},"payment-gateway":"Payment Gateway","payment_qr_codes":{"action":"Action","add_qr":"Add Qr","add_qr_code":"Add QR Code","default":"Default","edit_qr_code":"Edit QR Code","payment_qr_code":"Payment QR Code","payment_qr_codes":"Payment QR Codes","qr_code":"QR Code","qr_image":"QR Image","title":"Title"},"payments":"Payments","pdf_export":"PDF Export","placeholder":{"invalid_country_number":"Invalid country number","invalid_number":"Invalid number","select_tax":"Select Tax","too_long":"Too long","too_short":"Too short","valid_number":"Valid"},"product":{"add_product":"Add Product","category":"Category","code":"Product Code","description":"Description","edit_product":"Edit Product","image":"Image","name":"Name","price":"Price","product":"Product","product_details":"Product Details","product_name":"Product Name","unit_price":"Unit Price","updated_at":"Updated At"},"products":"Products","quote":{"add":"Add","add_note_term":"Add Note & Terms","amount":"Amount","client":"Client","client_email":"Client Email","client_id_required":"The Client ID is required.","client_name":"Client Name","client_overview":"CLIENT OVERVIEW","convert_to_invoice":"Convert To Invoice","discount":"Discount","discount_type":"Discount Type","download":"Download","due_amount":"Due Amount","due_date":"Due Date","edit_quote":"Edit Quote","excel_export":"Excel Export","issue_by":"Issued By","issue_for":"Issue For","make_payment":"Make Payment","new_quote":"New Quote","note":"Note","note_not_found":"Note Not Found","note_terms":"Note & Terms","overview":"Overview","paid":"Paid","paid_amount":"Paid Amount","payment":"Payment","payment_history":"Payment History","payment_method":"Payment Method","price":"Price","print_quote":"Print Quote","qty":"Qty","quote":"Quote","quote_date":"Quote Date","quote_details":"Quote Details","quote_id":"Quote ID","quote_name":"Quote","quote_number":"Quote Number","quote_pdf":"Quote","quote_url":"Quote URL","recurring":"Recurring","remaining_amount":"Remaining Amount","remove_note_term":"Remove Note & Terms","sub_total":"Sub Total","tax":"Tax","terms":"Terms","terms_not_found":"Terms Not Found","total":"Total","total_tax":"Tax","transactions":"Transactions"},"quotes":"Quotes","received_amount":"Received Amount","registered_date":"Registered Date","roles":"Roles","setting":{"address":"Address","app_logo":"App Logo","app_name":"App Name","approved":"Approved","auto_approve":"Auto Approve","clinic_name":"Clinic Name","color":"Color","company_address":"Company Address","company_image_validation":"The image must be of pixel 210 x 50.","company_logo":"Company Logo","company_name":"Company Name","company_phone":"Company Phone","contact_information":"Contact Information","country_code":"Country Code","currencies":"Currencies","currency_position":"Currency Position","currency_settings":"Currency Settings","date_format":"Date Format","decimal_separator":"Decimal Separator","denied":"Denied","fav_icon":"Favicon","general":"General","general_details":"General Details","image_validation":"The image must be of pixel 90 x 60.","invoice_no_prefix":"Invoice No Prefix","invoice_no_suffix":"Invoice No Suffix","invoice_settings":"Invoice Settings","invoice_template":"Invoice Template","mail_notifications":"Mail Notifications","manual_payment_approval":"Manual Payment Approval","payment_approved":"Payment Approved","payment_auto_approved":"Payment auto approval","paypal":"Paypal","paypal_client_id":"Paypal Client ID","paypal_secret":"Paypal Secret","postal_code":"Postal Code","prefix":"Prefix","razorpay":"Razorpay","razorpay_key":"Razorpay Key","razorpay_secret":"Razorpay Secret","select_manual_payment":"Select Manual Payment","send_due_invoice_email_before_x_days":"Send Due Invoice Email Before X Days","setting":"Setting","show_additional_address":"Show Additional Address In Invoice","show_currency_behind":"Show Currency Behind","show_product_description":"Show Product Description","specialities":"Specialities","stripe":"Stripe","stripe_key":"Stripe Key","stripe_secret":"Stripe Secret","thousand_separator":"Thousand Separator","time_format":"Time Format","timezone":"Time Zone","waiting_for_approval":"Waiting For Approval"},"settings":"Settings","sign_out":"Sign Out","states":"States","tax":{"add_tax":"Add Tax","edit_tax":"Edit Tax","is_default":"Is Default","no":"No","tax":"Tax","yes":"Yes"},"tax_information":"Tax Information","taxes":"Taxes","transactions":"Transactions","unpaid_invoices":"Unpaid Invoices","user":{"account":"Account","account_setting":"Account Settings","avatar":"Avatar","change_password":"Change Password","confirm_password":"Confirm Password","contact_number":"Contact Number","current_password":"Current Password","email":"Email","full_name":"Full Name","gender":"Gender","new_password":"New Password","phone":"Phone","phone_number":"Phone Number","profile":"Profile","profile_details":"Profile Details","save_changes":"Save Changes","setting":"Setting","user_details":"User Details"},"users":"Users","weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"}},"es.messages":{"add_admin":"Agregar administrador","admin":"Administrador","admin_dashboard":{"dashboard":"Tablero de mandos","day":"D\u00eda","income_overview":"Resumen de ingresos","invoice_overview":"Resumen de facturas","month":"Mes","monthly_income_overview":"Resumen de ingresos mensuales","name":"NOMBRE","no_record_found":"No se encontr\u00f3 ning\u00fan registro","payment_overview":"Resumen de pagos","registered":"REGISTRADO","total_amount":"Cantidad total","total_clients":"Total de clientes","total_due":"Total adeudado","total_invoices":"Facturas totales","total_overdue_invoice":"Total de facturas vencidas","total_paid":"Total pagado","total_paid_invoices":"Total de facturas pagadas","total_partial_paid_invoices":"Total de facturas pagadas parcialmente","total_payments":"Pagos totales","total_products":"Productos totales","total_unpaid_invoices":"Total de facturas impagas","week":"Semana","year":"a\u00f1o","yearly_income_overview":"Resumen de ingresos anuales"},"admin_details":"Detalles del administrador","admins":"administradores","apps":"Aplicaciones","categories":"Categor\u00edas","category":{"add_category":"Agregar categor\u00eda","category":"Categor\u00eda","edit_category":"Editar categor\u00eda"},"change_avatar":"Cambiar avatar","change_language":"Cambiar idioma","cities":"Ciudades","clear_cache":"Limpiar cache","client":{"add_client":"Agregar cliente","add_user":"Agregar usuario","address":"Direcci\u00f3n","city":"Ciudad","client":"Cliente","client_details":"Detalles del cliente","confirm_password":"Confirmar contrase\u00f1a","contact_no":"N\u00famero de contacto","country":"Pa\u00eds","created_at":"Fecha","edit_user":"Editar usuario","email":"Correo electr\u00f3nico","female":"Mujer","first_name":"Nombre","gender":"G\u00e9nero","last_name":"Apellido","male":"Hombre","note":"Nota","notes":"Notas","password":"Contrase\u00f1a","postal_code":"C\u00f3digo postal","profile":"Perfil","role":"Rol","state":"Estado","website":"Sitio web"},"client_address":"Direcci\u00f3n del cliente","clients":"Clientes","common":{"action":"Acci\u00f3n","actions":"Acciones","active":"Activo","add":"Agregar","address":"Direcci\u00f3n","allow_file_type":"Tipos de archivos permitidos","apply":"Aplicar","are_you_sure_delete":"Est\u00e1s seguro que quieres eliminar esto","attachment":"archivo adjunto","back":"Atr\u00e1s","cancel":"Cancelar","city":"Ciudad","click_here":"Haga clic aqu\u00ed","country":"Pa\u00eds","created_at":"Creado","custom":"Disfraz","de_active":"Desactivado","default":"Predeterminado","delete":"Eliminar","deleted":"Remoto!","details":"Detalles","discard":"Descartar","edit":"Editar","email":"Correo electr\u00f3nico","error":"Error","filter":"Filtro","filter_options":"Opciones de filtro","from":"De","has_been_deleted":"ha sido eliminado.","invoice":"FACTURA","last_update":"\u00daltima actualizaci\u00f3n","mo":"Mes","n\/a":"N\/A","name":"Nombre","no_cancel":"no, cancelar","ok":"okey","pay":"Pagar","payment_type":"Tipo de pago","please_wait":"Por favor espere ...","regards":"Saludos","reminder":"recordatorio","reset":"Reiniciar","save":"Guardar","save_draft":"Guardar como borrador","save_send":"Guardar y enviar","search":"B\u00fasqueda","service":"Servicio","state":"Estado","status":"Estado","submit":"Enviar","to":"A","updated_at":"Actualizado","value":"Valor","yes_delete":"S\u00ed, Eliminar!","zipcode":"C\u00f3digo postal"},"countries":"Pa\u00edses","currency":{"add_currency":"Agregar moneda","currency":"moneda","currency_code":"C\u00f3digo de moneda","edit_currency":"Editar moneda","icon":"Icono"},"currency_reports":"Informes de moneda","dashboard":"Tablero de mandos","datepicker":{"custom":"Rango personalizado","last_30_days":"\u00daltimos 30 d\u00edas","last_7_days":"Los \u00faltimos 7 d\u00edas","last_month":"El mes pasado","last_week":"La semana pasada","this_month":"Este mes","this_week":"Esta semana","today":"Este Dia","yesterday":"Ayer"},"edit_admin":"editar administrador","flash":{"Admin_cant_be_deleted":"El administrador no se puede eliminar","Admin_deleted_successfully":"Administrador eliminado con \u00e9xito","Invoice_send_successfully":"La factura se envi\u00f3 correctamente","admin_created_successfully":"Administrador creado exitosamente","admin_profile_updated_successfully":"Perfil de administrador actualizado con \u00e9xito","admin_updated_successfully":"Administrador actualizado con \u00e9xito","all_notification_read_successfully":"Todas las notificaciones se leyeron correctamente","allowed_file_types_png_jpg_jpeg":"Tipos de archivos permitidos: png, jpg, jpeg.","application_cache_cleared":"\u00a1Se ha borrado la memoria cach\u00e9 de la aplicaci\u00f3n!","are_sure_want_to_delete_this_client_related_all_invoices":"\u00bfEst\u00e1 seguro de que desea eliminar todas las facturas relacionadas con este cliente?","category_cant_deleted":"La categor\u00eda no se puede eliminar.","category_deleted_successfully":"Categor\u00eda eliminada exitosamente","category_retrieved_successfully":"Categor\u00eda recuperada exitosamente","category_saved_successfully":"Categor\u00eda guardada exitosamente","category_updated_successfully":"Categor\u00eda actualizada exitosamente","cities_retrieved_successfully":"Ciudades recuperadas con \u00e9xito","click_refresh_icon_generate_product_code":"Haga clic en el icono de actualizaci\u00f3n para generar el c\u00f3digo del producto","client_cant_deleted":"El cliente no se puede eliminar.","client_created_successfully":"Cliente creado exitosamente","client_deleted_successfully":"Cliente eliminado exitosamente","client_updated_successfully":"Cliente actualizado exitosamente","converted_quote_can_not_editable":"La cotizaci\u00f3n convertida no puede ser editable","converted_to_invoice_successfully":"Convertido a factura exitosamente","currency_cant_deleted":"Esta moneda se usa en otro lugar.","currency_deleted_successfully":"Moneda eliminada exitosamente","currency_saved_successfully":"Moneda guardada exitosamente.","currency_updated_successfully":"Moneda actualizada exitosamente","current_password_is_invalid":"La contrase\u00f1a actual no es v\u00e1lida","default_admin_can_not_editable":"El administrador predeterminado no puede editar","invoice_currency_retrieved_successfully":"La moneda de la factura se recuper\u00f3 correctamente","invoice_deleted_successfully":"Factura eliminada exitosamente","invoice_due_amount_retrieve_successfully":"El monto adeudado de la factura se recuper\u00f3 exitosamente","invoice_saved_and_sent_successfully":"Factura guardada y enviada correctamente","invoice_saved_successfully":"Factura guardada exitosamente","invoice_template_updated_successfully":"Plantilla de factura actualizada exitosamente","invoice_updated_and_send_successfully":"Factura actualizada y enviada correctamente","invoice_updated_successfully":"Factura actualizada exitosamente","language_updated_successfully":"Idioma actualizado correctamente","manual_payment_approved_successfully":"Pago manual aprobado con \u00e9xito","manual_payment_denied_successfully":"Pago manual denegado con \u00e9xito","note_retrieved_successfully":"Nota recuperada con \u00e9xito","notification_read_successfully":"Notificaci\u00f3n le\u00edda con \u00e9xito","number_of_days_for_recurring_cycle":"N\u00famero de d\u00edas para el ciclo recurrente","password_updated_successfully":"Contrase\u00f1a actualizada exitosamente","payment_deleted_successfully":"Pago eliminado exitosamente.","payment_overview_status_retrieved_successfully":"El estado de PaymentOverview se recuper\u00f3 correctamente","payment_qr_code_deleted_successfully":"C\u00f3digo qr de pago eliminado exitosamente","payment_qr_code_saved_successfully":"C\u00f3digo qr de pago guardado exitosamente","payment_qr_code_status_updated_successfully":"El estado del c\u00f3digo qr de pago se actualiz\u00f3 correctamente","payment_qr_code_updated_successfully":"C\u00f3digo qr de pago actualizado exitosamente","payment_reminder_mail_send_successfully":"Correo de recordatorio de pago enviado exitosamente","payment_saved_successfully":"Pago guardado exitosamente.","payment_updated_successfully":"Pago actualizado exitosamente.","product_cant_deleted":"No se puede eliminar el producto.","product_created_successfully":"Producto creado exitosamente","product_deleted_successfully":"Producto eliminado exitosamente","product_price_retrieved_successfully":"Precio del producto recuperado exitosamente","product_updated_successfully":"Producto actualizado exitosamente","quote_deleted_successfully":"Cita eliminada exitosamente","quote_saved_successfully":"Cotizaci\u00f3n guardada exitosamente","quote_updated_successfully":"Cotizaci\u00f3n actualizada exitosamente","recurring_status_updated_successfully":"Estado recurrente actualizado exitosamente","seems_you_are_not_allowed_to_access_this_record":"Parece que no tienes permiso para acceder a este registro.","select_currency":"Seleccione el tipo de moneda","select_payment_qr_code":"Seleccione el c\u00f3digo QR de pago","select_product_or_enter_free_text":"Seleccione Producto o Ingrese texto libre","setting_updated_successfully":"Configuraci\u00f3n actualizada exitosamente","status_retrieved_successfully":"Estado recuperado exitosamente","status_updated_successfully":"Estado actualizado con \u00e9xito","tax_can_not_deleted":"El impuesto no se puede eliminar.","tax_deleted_successfully":"Impuesto eliminado exitosamente","tax_retrieved_successfully":"Impuesto recuperado exitosamente","tax_saved_successfully":"Impuestos guardados exitosamente","tax_updated_successfully":"Impuesto actualizado exitosamente","yearly_income_overview_chart_data_retrieved_successfully":"Los datos del gr\u00e1fico general de ingresos anuales se recuperaron correctamente"},"general":"General","invoice":{"add":"Agregar","add_note_term":"Agregar nota y condiciones","amount":"Importe","amount_should_be_less_than_payable_amount":"El monto debe ser menor que el monto a pagar.","are_you_sure_send":"\u00bfEst\u00e1 seguro de que desea enviar esta factura al cliente?","client":"Cliente","client_email":"Correo electr\u00f3nico del cliente","client_name":"Nombre del cliente","client_overview":"DESCRIPCI\u00d3N GENERAL DEL CLIENTE","copy_invoice_url":"Copiar URL de factura","discount":"Descuento","discount_type":"Tipo de descuento","download":"Descargar","due_amount":"Importe adeudado","due_date":"Fecha de vencimiento","edit_invoice":"Editar factura","excel_export":"Exportaci\u00f3n de Excel","fax_no":"n\u00famero de fax","has_been_sent":"ha sido enviado.","invoice":"Factura","invoice_date":"Fecha de la factura","invoice_details":"Detalles de la factura","invoice_id":"ID de factura","invoice_number":"N\u00famero de factura","invoice_pdf":"Factura","invoice_url":"URL de la factura","issue_by":"Emitido por","issue_for":"Emitir para","last_recurring_on":"\u00daltimo recurrente en","make_payment":"Hacer el pago","new_invoice":"Nueva factura","note":"Nota","note_not_found":"Nota no encontrada","note_terms":"Nota y condiciones","nothing_amount_yet":"Nada cantidad todav\u00eda.","nothing_due_yet":"Nada pendiente todav\u00eda.","nothing_paid_yet":"Nada pagado todav\u00eda.","overview":"Resumen","paid":"Pagado","paid_amount":"Monto pagado","parent_invoice":"Factura principal","payment":"Pago","payment_history":"Historial de pagos","payment_method":"M\u00e9todo de pago","payment_reminder_mail":"Correo de recordatorio de pago","pdf_export":"PDF Export","price":"Precio","print_invoice":"Imprimir factura","qty":"Cantidad","recurring":"Recurrente","recurring_cycle":"Ciclo recurrente","recurring_invoices":"Facturas recurrentes","remaining_amount":"Cantidad restante","remove_note_term":"Eliminar nota y t\u00e9rminos","send":"Enviar","send_invoice":"Enviar factura","start_recurring":"empezar a repetir","stop_recurring":"dejar de repetir","sub_total":"Sub Total","tax":"Impuestos","terms":"Condiciones","terms_not_found":"T\u00e9rminos no encontrados","total":"Total","total_tax":"Impuestos","transactions":"Transacciones","yes_send":"S\u00ed, enviar"},"invoice_templates":"Plantillas de facturas","invoices":"Facturas","item":"Art\u00edculo","language":"Idioma","login":{"email":"Email","forget_your_password":"\u00bfOlvidaste tu contrase\u00f1a?","login":"Acceso","password":"Contrase\u00f1a","remember_me":"Acu\u00e9rdate de m\u00ed","sign_in":"Iniciar sesi\u00f3n"},"months":{"apr":"Abr","aug":"Ago","dec":"Dic","feb":"Feb","jan":"Ene","jul":"Jul","jun":"Jun","mar":"Mar","may":"Mayo","nov":"Nov","oct":"Oct","sep":"Sep"},"no_records_found":"No se encontraron registros.","notification":{"mark_all_as_read":"Marcar todo como le\u00eddo","notifications":"Notificaciones","you_don`t_have_any_new_notification":"No tienes ninguna notificaci\u00f3n nueva"},"paid_invoices":"Facturas pagadas","payment":{"add_payment":"Agregar pago","edit_payment":"Editar pago","payable_amount":"Monto a pagar","payment_amount":"Importe del pago","payment_date":"Fecha de pago","payment_method":"M\u00e9todo de pago","payment_mode":"Modo de pago","payment_type":"Tipo de pago","transaction_id":"Id de transacci\u00f3n","transaction_notes":"Notas de transacci\u00f3n"},"payment-gateway":"Pasarela de pago","payment_qr_codes":{"action":"Acci\u00f3n","add_qr":"A\u00f1adir QR","add_qr_code":"Agregar c\u00f3digo QR","default":"Por defecto","edit_qr_code":"Editar c\u00f3digo QR","payment_qr_code":"C\u00f3digo QR de pago","payment_qr_codes":"C\u00f3digos QR de pago","qr_code":"C\u00f3digo QR","qr_image":"Imagen QR","title":"T\u00edtulo"},"payments":"Pagos","pdf_export":"Exportaci\u00f3n de PDF","placeholder":{"invalid_country_number":"N\u00famero de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","select_tax":"Seleccionar Impuesto","too_long":"Demasiado largo","too_short":"Demasiado corto","valid_number":"N\u00famero v\u00e1lido"},"product":{"add_product":"Agregar producto","category":"Categor\u00eda","code":"C\u00f3digo de producto","description":"Descripci\u00f3n","edit_product":"Editar producto","image":"Imagen","name":"Nombre","price":"Precio","product":"Producto","product_details":"Detalles del producto","product_name":"Nombre del producto","unit_price":"Precio unitario","updated_at":"Actualizado en"},"products":"Productos","quote":{"add":"Agregar","add_note_term":"Agregar nota y condiciones","amount":"Importe","client":"Cliente","client_email":"Correo electr\u00f3nico del cliente","client_id_required":"El ID de cliente es obligatorio.","client_name":"Nombre del cliente","client_overview":"DESCRIPCI\u00d3N GENERAL DEL CLIENTE","convert_to_invoice":"Convertir en factura","discount":"Descuento","discount_type":"Tipo de descuento","download":"Descargar","due_amount":"Importe adeudado","due_date":"Fecha de vencimiento","edit_quote":"Editar cotizaci\u00f3n","excel_export":"Exportaci\u00f3n de Excel","invoice_date":"Fecha de la factura","issue_by":"Emitido por","issue_for":"Emitir para","make_payment":"Hacer el pago","new_quote":"Nueva Cotizaci\u00f3n","note":"Nota","note_not_found":"Nota no encontrada","note_terms":"Nota y condiciones","overview":"Resumen","paid":"Pagado","paid_amount":"Monto pagado","payment":"Pago","payment_history":"Historial de pagos","payment_method":"M\u00e9todo de pago","price":"Precio","print_quote":"Imprimir cotizaci\u00f3n","qty":"Cantidad","quote":"cita","quote_date":"Fecha de cotizaci\u00f3n","quote_details":"Detalles de cotizaci\u00f3n","quote_id":"ID de cotizaci\u00f3n","quote_name":"Cita","quote_number":"N\u00famero de cotizaci\u00f3n","quote_pdf":"Cita","quote_url":"URL de cotizaci\u00f3n","recurring":"Recurrente","remaining_amount":"Cantidad restante","remove_note_term":"Eliminar nota y t\u00e9rminos","sub_total":"Sub Total","tax":"Impuestos","terms":"Condiciones","terms_not_found":"T\u00e9rminos no encontrados","total":"Total","total_tax":"Impuestos","transactions":"Transacciones"},"quotes":"Cotizaciones","received_amount":"Cantidad recibida","registered_date":"La fecha registrada","roles":"Roles","setting":{"address":"Direcci\u00f3n","app_logo":"Logotipo de la aplicaci\u00f3n","app_name":"Nombre de la aplicaci\u00f3n","auto_approve":"Aprobar autom\u00e1ticamente","clinic_name":"Nombre de la cl\u00ednica","color":"Color","company_address":"Direcci\u00f3n de la empresa","company_image_validation":"La imagen debe tener un tama\u00f1o de p\u00edxel 210 x 50.","company_logo":"Logotipo de la empresa","company_name":"Nombre de la empresa","company_phone":"Tel\u00e9fono de la empresa","contact_information":"Informaci\u00f3n de contacto","country_code":"C\u00f3digo de pa\u00eds","currencies":"monedas","currency_position":"Posici\u00f3n de moneda","currency_settings":"Configuraci\u00f3n de moneda","date_format":"Formato de fecha","decimal_separator":"Separador decimal","fav_icon":"Favicon","general":"General","general_details":"Detalles generales","image_validation":"La imagen debe tener un tama\u00f1o de p\u00edxel 90 x 60.","invoice_no_prefix":"Factura sin prefijo","invoice_no_suffix":"Factura sin sufijo","invoice_settings":"Configuraci\u00f3n de factura","invoice_template":"Plantilla de factura","mail_notifications":"Notificaciones de correo","manual_payment_approval":"Aprobaci\u00f3n de pago manual","payment_approved":"Pago aprobado","payment_auto_approved":"Aprobaci\u00f3n autom\u00e1tica de pago","paypal":"Paypal","paypal_client_id":"ID de cliente de Paypal","paypal_secret":"Secreto de Paypal","postal_code":"C\u00f3digo postal","prefix":"Prefijo","razorpay":"Razorpay","razorpay_key":"Clave RazorPay","razorpay_secret":"Secreto de Razorpay","send_due_invoice_email_before_x_days":"Enviar correo electr\u00f3nico de factura vencida antes de X d\u00edas","setting":"Configuraci\u00f3n","show_additional_address":"Mostrar direcci\u00f3n adicional en la factura","show_currency_behind":"Mostrar moneda detr\u00e1s","show_product_description":"Mostrar descripci\u00f3n del producto","specialities":"Especialidades","stripe":"Raya","stripe_key":"Clave de rayas","stripe_secret":"Secreto de rayas","thousand_separator":"Separador de mil","time_format":"Formato de hora","timezone":"Zona horaria"},"settings":"Configuraci\u00f3n","sign_out":"Cerrar sesi\u00f3n","states":"Estados","tax":{"add_tax":"Agregar impuestos","edit_tax":"Editar impuesto","is_default":"Es predeterminado","no":"No","tax":"Impuestos","yes":"S\u00ed"},"tax_information":"Informaci\u00f3n sobre los impuestos","taxes":"Impuestos","transactions":"Transacciones","unpaid_invoices":"Facturas impagas","user":{"account":"Cuenta","account_setting":"Configuraci\u00f3n de la cuenta","avatar":"Avatar","change_password":"Cambiar contrase\u00f1a","confirm_password":"Confirmar contrase\u00f1a","contact_number":"N\u00famero de contacto","current_password":"Contrase\u00f1a actual","email":"Correo electr\u00f3nico","full_name":"Nombre completo","gender":"G\u00e9nero","new_password":"Nueva contrase\u00f1a","phone":"Tel\u00e9fono","phone_number":"N\u00famero de Tel\u00e9fono","profile":"Perfil","profile_details":"Detalles del perfil","save_changes":"Guardar cambios","setting":"Configuraci\u00f3n","user_details":"Detalles del usuario"},"users":"Usuarios","weekdays":{"fri":"VIE","mon":"LUN","sat":"Se sent\u00f3","sun":"SOL","thu":"JUE","tue":"MAR","wed":"CASARSE"}},"fr.messages":{"add_admin":"ajouter un administrateur","admin":"administrateur","admin_dashboard":{"dashboard":"Tableau de bord","day":"Jour","income_overview":"R\u00e9sum\u00e9 de la facture","invoice_overview":"Aper\u00e7u des factures","month":"Mois","monthly_income_overview":"Aper\u00e7u du revenu mensuel","name":"NOM","no_record_found":"Aucun enregistrement trouv\u00e9","payment_overview":"Aper\u00e7u des paiements","registered":"INSCRITE","total_amount":"Montant total","total_clients":"Total Clients","total_due":"Total d\u00fb","total_invoices":"Total des factures","total_overdue_invoice":"Total des factures en retard","total_paid":"Total Pay\u00e9","total_paid_invoices":"Total des factures pay\u00e9es","total_partial_paid_invoices":"Total des factures partiellement pay\u00e9es","total_payments":"Total des paiements","total_products":"Total des produits","total_unpaid_invoices":"Total des factures impay\u00e9es","week":"La semaine","year":"an","yearly_income_overview":"Aper\u00e7u des revenus annuels"},"admin_details":"D\u00e9tails de l'administrateur","admins":"administrateurs","apps":"applications","categories":"Cat\u00e9gories","category":{"add_category":"Ajouter une cat\u00e9gorie","category":"Cat\u00e9gorie","edit_category":"Modifier la cat\u00e9gorie"},"change_avatar":"Changer d'avatar","change_language":"Changer de langue","cities":"Villes","clear_cache":"Vider le cache","client":{"add_client":"Ajouter un client","add_user":"Ajouter un utilisateur","address":"Adresse","city":"Ville","client":"Client","client_details":"D\u00e9tails du client","confirm_password":"Confirmer le mot de passe","contact_no":"No de contact","country":"Pays","created_at":"Date","edit_user":"Modifier l'utilisateur","email":"E-mail","female":"Femme","first_name":"Pr\u00e9nom","gender":"Genre","last_name":"Nom de famille","male":"Homme","note":"Note","notes":"Notes","password":"Mot de passe","postal_code":"Code Postal","profile":"Profil","role":"R\u00f4le","state":"\u00c9tat","website":"Site"},"client_address":"Adresse client","clients":"Clientes","common":{"action":"action","actions":"Actions","active":"Actif","add":"Ajouter","address":"Adresse","allow_file_type":"Types de fichiers autoris\u00e9s","apply":"Appliquer","are_you_sure_delete":"\u00cates-vous s\u00fbr de vouloir supprimer ce","attachment":"attachement","back":"Retour","cancel":"Annuler","city":"Ville","click_here":"Cliquez ici","country":"Pays","created_at":"Cr\u00e9\u00e9","custom":"Personnalis\u00e9","de_active":"D\u00e9sactiv\u00e9","default":"Default","delete":"Supprimer","deleted":"Supprim\u00e9!","details":"D\u00e9tails","discard":"rejeter","edit":"Edit","email":"E-mail","error":"Erreur","filter":"Filtre","filter_options":"Options de filtrage","from":"De","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","invoice":"FACTURE","last_update":"Derni\u00e8re mise \u00e0 jour","mo":"mois","n\/a":"N\/A","name":"Nom","no_cancel":"non, annuler","ok":"D'accord","pay":"Payer","payment_type":"Type de paiement","please_wait":"Veuillez patienter...","regards":"Salutations","reminder":"rappel","reset":"Reset","save":"Enregistrer","save_draft":"Enregistrer comme brouillon","save_send":"Enregistrer et envoyer","search":"Chercher","service":"service","state":"\u00c9tat","status":"Statut","submit":"Soumettre","to":"\u00c0","updated_at":"Mise \u00e0 jour","value":"Valeur","yes_delete":"Oui, supprimer!","zipcode":"Code postal"},"countries":"Des pays","currency":{"add_currency":"Ajouter une devise","currency":"devise","currency_code":"Code de devise","edit_currency":"Modifier la devise","icon":"Ic\u00f4ne"},"currency_reports":"Rapports sur les devises","dashboard":"Tableau de bord","datepicker":{"custom":"Plage personnalis\u00e9e","last_30_days":"Les 30 derniers jours","last_7_days":"Les 7 derniers jours","last_month":"Le mois dernier","last_week":"La semaine derni\u00e8re","this_month":"Ce mois-ci","this_week":"Cette semaine","today":"Aujourd'hui","yesterday":"Hier"},"edit_admin":"modifier l'administrateur","flash":{"Admin_cant_be_deleted":"L'administrateur ne peut pas \u00eatre supprim\u00e9","Admin_deleted_successfully":"Administrateur supprim\u00e9 avec succ\u00e8s","Invoice_send_successfully":"Facture envoy\u00e9e avec succ\u00e8s","admin_created_successfully":"Administrateur cr\u00e9\u00e9 avec succ\u00e8s","admin_profile_updated_successfully":"Profil d'administrateur mis \u00e0 jour avec succ\u00e8s","admin_updated_successfully":"Admin mis \u00e0 jour avec succ\u00e8s","all_notification_read_successfully":"Toutes les notifications ont \u00e9t\u00e9 lues avec succ\u00e8s","allowed_file_types_png_jpg_jpeg":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","application_cache_cleared":"Cache de l'application vid\u00e9 !","are_sure_want_to_delete_this_client_related_all_invoices":"Voulez-vous vraiment supprimer toutes les factures li\u00e9es \u00e0 ce client ?","category_cant_deleted":"La cat\u00e9gorie ne peut pas \u00eatre supprim\u00e9e.","category_deleted_successfully":"Cat\u00e9gorie supprim\u00e9e avec succ\u00e8s","category_retrieved_successfully":"Cat\u00e9gorie r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s","category_saved_successfully":"Cat\u00e9gorie enregistr\u00e9e avec succ\u00e8s","category_updated_successfully":"Cat\u00e9gorie mise \u00e0 jour avec succ\u00e8s","cities_retrieved_successfully":"Villes r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s","click_refresh_icon_generate_product_code":"Cliquez sur l'ic\u00f4ne d'actualisation pour g\u00e9n\u00e9rer le code produit","client_cant_deleted":"Le client ne peut pas \u00eatre supprim\u00e9.","client_created_successfully":"Client cr\u00e9\u00e9 avec succ\u00e8s","client_deleted_successfully":"Client supprim\u00e9 avec succ\u00e8s","client_updated_successfully":"Client mis \u00e0 jour avec succ\u00e8s","converted_quote_can_not_editable":"Le devis converti ne peut pas \u00eatre modifi\u00e9","converted_to_invoice_successfully":"Converti en facture avec succ\u00e8s","currency_cant_deleted":"Cette devise est utilis\u00e9e ailleurs.","currency_deleted_successfully":"Devise supprim\u00e9e avec succ\u00e8s","currency_saved_successfully":"Devise enregistr\u00e9e avec succ\u00e8s.","currency_updated_successfully":"Devise mise \u00e0 jour avec succ\u00e8s","current_password_is_invalid":"Le mot de passe actuel n'est pas valide","default_admin_can_not_editable":"L'administrateur par d\u00e9faut ne peut pas \u00eatre modifi\u00e9","invoice_currency_retrieved_successfully":"Devise de la facture r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s","invoice_deleted_successfully":"Facture supprim\u00e9e avec succ\u00e8s","invoice_due_amount_retrieve_successfully":"Montant de la facture d\u00fb r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","invoice_saved_and_sent_successfully":"Facture enregistr\u00e9e et envoy\u00e9e avec succ\u00e8s","invoice_saved_successfully":"Facture enregistr\u00e9e avec succ\u00e8s","invoice_template_updated_successfully":"Mod\u00e8le de facture mis \u00e0 jour avec succ\u00e8s","invoice_updated_and_send_successfully":"Facture mise \u00e0 jour et envoy\u00e9e avec succ\u00e8s","invoice_updated_successfully":"Facture mise \u00e0 jour avec succ\u00e8s","language_updated_successfully":"Langue mise \u00e0 jour avec succ\u00e8s","manual_payment_approved_successfully":"Paiement manuel approuv\u00e9 avec succ\u00e8s","manual_payment_denied_successfully":"Paiement manuel refus\u00e9 avec succ\u00e8s","note_retrieved_successfully":"Note r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s","notification_read_successfully":"Notification lue avec succ\u00e8s","number_of_days_for_recurring_cycle":"Nombre de jours pour le cycle r\u00e9current","password_updated_successfully":"Mot de passe mis \u00e0 jour avec succ\u00e8s","payment_deleted_successfully":"Paiement supprim\u00e9 avec succ\u00e8s.","payment_overview_status_retrieved_successfully":"Statut PaymentOverview r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","payment_qr_code_deleted_successfully":"Code QR de paiement supprim\u00e9 avec succ\u00e8s","payment_qr_code_saved_successfully":"Code QR de paiement enregistr\u00e9 avec succ\u00e8s","payment_qr_code_status_updated_successfully":"Le statut du code QR de paiement a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s","payment_qr_code_updated_successfully":"Code QR de paiement mis \u00e0 jour avec succ\u00e8s","payment_reminder_mail_send_successfully":"Mail de rappel de paiement envoy\u00e9 avec succ\u00e8s","payment_saved_successfully":"Paiement enregistr\u00e9 avec succ\u00e8s.","payment_updated_successfully.":"Paiement mis \u00e0 jour avec succ\u00e8s.","product_cant_deleted":"Le produit ne peut pas \u00eatre supprim\u00e9.","product_created_successfully":"Produit cr\u00e9\u00e9 avec succ\u00e8s","product_deleted_successfully":"Produit supprim\u00e9 avec succ\u00e8s","product_price_retrieved_successfully":"Prix du produit r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","product_updated_successfully":"Produit mis \u00e0 jour avec succ\u00e8s","quote_deleted_successfully":"Citation supprim\u00e9e avec succ\u00e8s","quote_saved_successfully":"Devis enregistr\u00e9 avec succ\u00e8s","quote_updated_successfully":"Devis mis \u00e0 jour avec succ\u00e8s","recurring_status_updated_successfully":"Statut r\u00e9current mis \u00e0 jour avec succ\u00e8s","seems_you_are_not_allowed_to_access_this_record":"Il semble que vous n'\u00eates pas autoris\u00e9 \u00e0 acc\u00e9der \u00e0 cet enregistrement.","select_currency":"S\u00e9lectionnez la devise","select_payment_qr_code":"S\u00e9lectionnez le code QR de paiement","select_product_or_enter_free_text":"S\u00e9lectionnez un produit ou saisissez un texte libre","setting_updated_successfully":"Param\u00e8tre mis \u00e0 jour avec succ\u00e8s","status_retrieved_successfully":"Statut r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","status_updated_successfully":"Statut mis \u00e0 jour avec succ\u00e8s","tax_can_not_deleted":"La taxe ne peut pas \u00eatre supprim\u00e9e.","tax_deleted_successfully":"Taxe supprim\u00e9e avec succ\u00e8s","tax_retrieved_successfully":"Taxe r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s","tax_saved_successfully":"Taxe \u00e9conomis\u00e9e avec succ\u00e8s","tax_updated_successfully":"Taxe mise \u00e0 jour avec succ\u00e8s","yearly_income_overview_chart_data_retrieved_successfully":"Donn\u00e9es du graphique d'aper\u00e7u des revenus annuels r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s"},"general":"G\u00e9n\u00e9rale","invoice":{"add":"Ajouter","add_note_term":"Ajouter une note et des conditions","amount":"Montant","amount_should_be_less_than_payable_amount":"Le montant doit \u00eatre inf\u00e9rieur au montant \u00e0 payer.","are_you_sure_send":"Etes-vous s\u00fbr de vouloir envoyer cette facture au client ?","client":"Client","client_email":"Courriel du client","client_id_required":"L'identifiant client est requis.","client_name":"Nom du client","client_overview":"PRESENTATION CLIENT","copy_invoice_url":"Copier l'URL de la facture","discount":"Remise","discount_type":"Type de remise","download":"T\u00e9l\u00e9charger","due_amount":"Montant d\u00fb","due_date":"Date d'\u00e9ch\u00e9ance","edit_invoice":"Modifier la facture","excel_export":"Exportation Excel","fax_no":"num\u00e9ro de fax","has_been_sent":"a \u00e9t\u00e9 envoy\u00e9.","invoice":"Facture","invoice_date":"Date de la facture","invoice_details":"D\u00e9tails de la facture","invoice_id":"Identifiant de la facture","invoice_number":"Num\u00e9ro de facture","invoice_pdf":"Facture","invoice_url":"URL de la facture","issue_by":"\u00c9mis par","issue_for":"Probl\u00e8me pour","last_recurring_on":"Derni\u00e8re r\u00e9currence le","make_payment":"Effectuer le paiement","new_invoice":"Nouvelle facture","note":"Note","note_not_found":"Note introuvable","note_terms":"Note & Termes","nothing_amount_yet":"Rien ne s'\u00e9l\u00e8ve encore.","nothing_due_yet":"Rien n'est encore d\u00fb.","nothing_paid_yet":"Rien encore pay\u00e9.","overview":"Aper\u00e7u","paid":"pay\u00e9","paid_amount":"Montant pay\u00e9","parent_invoice":"Facture parentale","payment":"Paiement","payment_history":"Historique des paiements","payment_method":"Mode de paiement","payment_reminder_mail":"Courriel de rappel de paiement","pdf_export":"PDF Export","price":"Prix","print_invoice":"Imprimer la facture","qty":"Qty","recurring":"R\u00e9current","recurring_cycle":"Cycle r\u00e9current","recurring_invoices":"Factures r\u00e9currentes","remaining_amount":"Montant restant","remove_note_term":"Supprimer la note et les conditions","send":"Envoyer","send_invoice":"Envoyer la facture","start_recurring":"commencer \u00e0 r\u00e9p\u00e9ter","stop_recurring":"arr\u00eater de se reproduire","sub_total":"Sous-total","tax":"Taxe","terms":"Termes","terms_not_found":"Termes non trouv\u00e9s","total":"Total","total_tax":"Taxe","transactions":"Transactions","yes_send":"Oui, envoyer"},"invoice_templates":"Mod\u00e8les de facture","invoices":"Factures","item":"Article","language":"Langue","login":{"email":"E-mail","forget_your_password":"Mot de passe oubli\u00e9?","login":"Connexion","password":"Mot de passe","remember_me":"Souviens-toi de moi","sign_in":"S'identifier"},"months":{"apr":"Avr","aug":"Ao\u00fbt","dec":"D\u00e9c","feb":"F\u00e9v","jan":"Jan","jul":"Juil","jun":"Juin","mar":"Mar","may":"Peut","nov":"Nov","oct":"Oct","sep":"Sep"},"no_records_found":"Aucun enregistrement trouv\u00e9.","notification":{"mark_all_as_read":"Marquer tout comme lu","notifications":"Notifications","you_don`t_have_any_new_notification":"Vous n'avez aucune nouvelle notification"},"paid_invoices":"Factures pay\u00e9es","payment":{"add_payment":"Ajouter un paiement","edit_payment":"Modifier le paiement","payable_amount":"Montant \u00e0 payer","payment_amount":"Montant du paiement","payment_date":"Date de paiement","payment_method":"Mode de paiement","payment_mode":"Mode de paiement","payment_type":"Type de paiement","transaction_id":"Identifiant de la transaction","transaction_notes":"Notes de transaction"},"payment-gateway":"Passerelle de paiement","payment_qr_codes":{"action":"Action","add_qr":"Ajouter Qr","add_qr_code":"Ajouter un code QR","default":"D\u00e9faut","edit_qr_code":"Modifier le code QR","payment_qr_code":"Code QR de paiement","payment_qr_codes":"Code QR de paiement","qr_code":"QR Code","qr_image":"QR Image","title":"Titre"},"payments":"Paiements","pdf_export":"Exportation PDF","placeholder":{"invalid_country_number":"Num\u00e9ro de pays invalide","invalid_number":"Num\u00e9ro invalide","select_tax":"S\u00e9lectionner taxe","too_long":"Trop long","too_short":"Trop court","valid_number":"Nombre valide"},"product":{"add_product":"Ajouter un produit","category":"Cat\u00e9gorie","code":"Code Produit","description":"Description","edit_product":"Modifier le produit","image":"Image","name":"Nom","price":"Prix","product":"Produit","product_details":"D\u00e9tails du produit","product_name":"Nom du produit","unit_price":"Prix unitaire","updated_at":"Mise \u00e0 jour \u00e0"},"products":"Des produits","quote":{"add":"Ajouter","add_note_term":"Ajouter une note et des conditions","amount":"Montant","client":"Client","client_email":"Courriel du client","client_name":"Nom du client","client_overview":"PRESENTATION CLIENT","convert_to_invoice":"Convertir en facture","discount":"Remise","discount_type":"Type de remise","download":"T\u00e9l\u00e9charger","due_amount":"Montant d\u00fb","due_date":"Date d'\u00e9ch\u00e9ance","edit_quote":"Modifier le devis","excel_export":"Exportation Excel","invoice_date":"Date de la facture","issue_by":"\u00c9mis par","issue_for":"Probl\u00e8me pour","make_payment":"Effectuer le paiement","new_quote":"Nouvelle cotation","note":"Note","note_not_found":"Note introuvable","note_terms":"Note & Termes","overview":"Aper\u00e7u","paid":"pay\u00e9","paid_amount":"Montant pay\u00e9","payment":"Paiement","payment_history":"Historique des paiements","payment_method":"Mode de paiement","price":"Prix","print_quote":"Imprimer le devis","qty":"Qty","quote":"Citation","quote_date":"Date du devis","quote_details":"D\u00e9tails du devis","quote_id":"Identifiant du devis","quote_name":"Citation","quote_number":"Num\u00e9ro de devis","quote_pdf":"Citation","quote_url":"Citer l URL","recurring":"R\u00e9current","remaining_amount":"Montant restant","remove_note_term":"Supprimer la note et les conditions","sub_total":"Sous-total","tax":"Taxe","terms":"Termes","terms_not_found":"Termes non trouv\u00e9s","total":"Total","total_tax":"Taxe","transactions":"Transactions"},"quotes":"Devis","received_amount":"Montant re\u00e7u","registered_date":"Date d'enregistrement","roles":"Les r\u00f4les","setting":{"address":"Adresse","app_logo":"Logo de l'application","app_name":"App Name","auto_approve":"Approuver automatiquement","clinic_name":"Nom de la clinique","color":"Couleur","company_address":"Adresse de l'entreprise","company_image_validation":"L'image doit \u00eatre au pixel 210 x 50.","company_logo":"Logo de l'entreprise","company_name":"Nom de l'entreprise","company_phone":"T\u00e9l\u00e9phone de l'entreprise","contact_information":"Coordonn\u00e9es","country_code":"Indicatif du pays","currencies":"Devises","currency_position":"Position de la devise","currency_settings":"Param\u00e8tres de devise","date_format":"Format de date","decimal_separator":"S\u00e9parateur d\u00e9cimal","fav_icon":"Favicon","general":"G\u00e9n\u00e9ral","general_details":"D\u00e9tails g\u00e9n\u00e9raux","image_validation":"L'image doit \u00eatre de pixel 90 x 60.","invoice_no_prefix":"Facture sans pr\u00e9fixe","invoice_no_suffix":"Facture sans suffixe","invoice_settings":"Param\u00e8tres de facturation","invoice_template":"Mod\u00e8le de facture","mail_notifications":"Notifications par courrier","manual_payment_approval":"Approbation manuelle du paiement","payment_approved":"Paiement approuv\u00e9","payment_auto_approved":"Approbation automatique des paiements","paypal":"Pay Pal","paypal_client_id":"Identifiant client Paypal","paypal_secret":"Secret Paypal","postal_code":"Code Postal","prefix":"Pr\u00e9fixe","razorpay":"Razorpay","razorpay_key":"Razorpay Anahtar\u0131","razorpay_secret":"Le secret de Razorpay","send_due_invoice_email_before_x_days":"Envoyer un e-mail de facture due avant X jours","setting":"Setting","show_additional_address":"Afficher l'adresse suppl\u00e9mentaire sur la facture","show_currency_behind":"Afficher la devise derri\u00e8re","show_product_description":"Afficher la description du produit","specialities":"Sp\u00e9cialit\u00e9s","stripe":"Band\u00e9","stripe_key":"Cl\u00e9 \u00e0 rayures","stripe_secret":"Secret de la rayure","thousand_separator":"Mille S\u00e9parateur","time_format":"Format de l'heure","timezone":"Time Zone"},"settings":"Param\u00e8tres","sign_out":"Se d\u00e9connecter","states":"\u00c9tats","tax":{"add_tax":"Ajouter une taxe","edit_tax":"Modifier la taxe","is_default":"Est par d\u00e9faut","no":"Non","tax":"Taxe","yes":"Oui"},"tax_information":"Informations fiscales","taxes":"Imp\u00f4ts","transactions":"Transactions","unpaid_invoices":"Factures impay\u00e9es","user":{"account":"Compte","account_setting":"Param\u00e8tres du compte","avatar":"Avatar","change_password":"Changer le mot de passe","confirm_password":"Confirmer le mot de passe","contact_number":"Num\u00e9ro de contact","current_password":"Mot de passe actuel","email":"E-mail","full_name":"Nom complet","gender":"Genre","new_password":"Nouveau mot de passe","phone":"T\u00e9l\u00e9phone","phone_number":"Num\u00e9ro de T\u00e9l\u00e9phone","profile":"Profil","profile_details":"D\u00e9tails du profil","save_changes":"Enregistrer les modifications","setting":"Setting","user_details":"D\u00e9tails de l'utilisateur"},"users":"Utilisatrices","weekdays":{"fri":"VEN","mon":"LUN","sat":"Assis","sun":"SOLEIL","thu":"JEU","tue":"MAR","wed":"\u00c9POUSER"}},"pt.messages":{"add_admin":"adicionar administrador","admin":"administrador","admin_dashboard":{"dashboard":"Painel","day":"Dia","income_overview":"Vis\u00e3o geral da receita","invoice_overview":"Vis\u00e3o geral das faturas","month":"M\u00eas","monthly_income_overview":"Vis\u00e3o geral da renda mensal","name":"NOME","no_record_found":"Nenhum registro encontrado","payment_overview":"Vis\u00e3o geral do pagamento","registered":"REGISTRADA","total_amount":"Valor total","total_clients":"Total de clientes","total_due":"Total devido","total_invoices":"Total de faturas","total_overdue_invoice":"Total de faturas em atraso","total_paid":"Total pago","total_paid_invoices":"Total de faturas pagas","total_partial_paid_invoices":"Total de faturas parcialmente pagas","total_payments":"Total de pagamentos","total_products":"Total de produtos","total_unpaid_invoices":"Total de faturas n\u00e3o pagas","week":"Semana","year":"ano","yearly_income_overview":"Vis\u00e3o geral da renda anual"},"admin_details":"Detalhes do administrador","admins":"administradores","apps":"Apps","categories":"Categorias","category":{"add_category":"Adicionar categoria","category":"Categoria","edit_category":"Editar categoria"},"change_avatar":"mudar Avatar","change_language":"Mudar idioma","cities":"Cidades","clear_cache":"Limpar cache","client":{"add_client":"Adicionar cliente","add_user":"Adicionar usu\u00e1rio","address":"Endere\u00e7o","city":"Cidade","client":"Cliente","client_details":"Detalhes do cliente","confirm_password":"Confirmar senha","contact_no":"Contato N\u00e3o","country":"Pa\u00eds","created_at":"Encontro","edit_user":"Editar usu\u00e1rio","email":"Email","female":"Feminino","first_name":"Nome","gender":"Sexo","last_name":"Sobrenome","male":"Masculino","note":"Nota","notes":"Notas","password":"Senha","postal_code":"C\u00f3digo postal","profile":"Perfil","role":"Fun\u00e7\u00e3o","state":"Estado","website":"Site"},"client_address":"Endere\u00e7o do cliente","clients":"Clientes","common":{"action":"A\u00e7\u00e3o","actions":"A\u00e7\u00f5es","active":"Ativo","add":"Adicionar","address":"Endere\u00e7o","allow_file_type":"Tipos de arquivo permitidos","apply":"Aplicar","are_you_sure_delete":"Tem certeza de que deseja excluir isso","attachment":"acess\u00f3rio","back":"Voltar","cancel":"Cancelar","city":"Cidade","click_here":"Clique aqui","country":"Pa\u00eds","created_at":"Criado","custom":"Personalizado","de_active":"Desativado","default":"Padr\u00e3o","delete":"Excluir","deleted":"deletado!","details":"Detalhes","discard":"Descartar","edit":"Editar","email":"O email","error":"Erro","filter":"Filtro","filter_options":"Op\u00e7\u00f5es de filtro","from":"A partir de","has_been_deleted":"ele foi deletado.","invoice":"FATURA","last_update":"\u00daltima atualiza\u00e7\u00e3o","mo":"Mo","n\/a":"N\/A","name":"Nome","no_cancel":"n\u00e3o, cancelar","ok":"OK","pay":"Pagar","payment_type":"Tipo de pagamento","please_wait":"Por favor, aguarde ...","regards":"Cumprimentos","reminder":"lembrete","reset":"Redefinir","save":"Salvar","save_draft":"Salvar como rascunho","save_send":"Salvar e enviar","search":"Procurar","service":"Servi\u00e7o","state":"Estado","status":"Status","submit":"Enviar","to":"Para","updated_at":"Atualizado","value":"Valor","yes_delete":"sim, excluir!","zipcode":"CEP"},"countries":"Pa\u00edses","currency":{"add_currency":"Adicionar moeda","currency":"moeda","currency_code":"C\u00f3digo da moeda","edit_currency":"Editar moeda","icon":"\u00cdcone"},"currency_reports":"Relat\u00f3rios de Moeda","dashboard":"Painel","datepicker":{"custom":"Intervalo personalizado","last_30_days":"\u00daltimos 30 dias","last_7_days":"\u00daltimos 7 dias","last_month":"M\u00eas passado","last_week":"Semana passada","this_month":"Este m\u00eas","this_week":"Essa semana","today":"Hoje","yesterday":"Ontem"},"edit_admin":"editar administrador","flash":{"Admin_cant_be_deleted":"Administrador n\u00e3o pode ser exclu\u00eddo","Admin_deleted_successfully":"Administrador exclu\u00eddo com sucesso","Invoice_send_successfully":"Fatura enviada com sucesso","admin_created_successfully":"Administrador criado com sucesso","admin_profile_updated_successfully":"Perfil de administrador atualizado com sucesso","admin_updated_successfully":"Administrador atualizado com sucesso","all_notification_read_successfully":"Todas as notifica\u00e7\u00f5es lidas com sucesso","allowed_file_types_png_jpg_jpeg":"Tipos de arquivos permitidos: png, jpg, jpeg.","application_cache_cleared":"Cache do aplicativo limpo!","are_sure_want_to_delete_this_client_related_all_invoices":"Tem certeza de que deseja excluir todas as faturas relacionadas a este cliente?","category_cant_deleted":"A categoria n\u00e3o pode ser exclu\u00edda.","category_deleted_successfully":"Categoria exclu\u00edda com sucesso","category_retrieved_successfully":"Categoria recuperada com sucesso","category_saved_successfully":"Categoria salva com sucesso","category_updated_successfully":"Categoria atualizada com sucesso","cities_retrieved_successfully":"Cidades recuperadas com sucesso","click_refresh_icon_generate_product_code":"Clique no \u00edcone de atualiza\u00e7\u00e3o para gerar o c\u00f3digo do produto","client_cant_deleted":"Cliente n\u00e3o pode ser exclu\u00eddo.","client_created_successfully":"Cliente criado com sucesso","client_deleted_successfully":"Cliente deletado com sucesso","client_updated_successfully":"Cliente atualizado com sucesso","converted_quote_can_not_editable":"A cota\u00e7\u00e3o convertida n\u00e3o pode ser edit\u00e1vel","converted_to_invoice_successfully":"Convertido em fatura com sucesso","currency_cant_deleted":"Esta moeda \u00e9 usada em outro lugar.","currency_deleted_successfully":"Moeda exclu\u00edda com sucesso","currency_saved_successfully":"Moeda salva com sucesso.","currency_updated_successfully":"Moeda atualizada com sucesso","current_password_is_invalid":"A senha atual \u00e9 inv\u00e1lida","default_admin_can_not_editable":"Administrador padr\u00e3o n\u00e3o pode ser editado","invoice_currency_retrieved_successfully":"Moeda da fatura recuperada com sucesso","invoice_deleted_successfully":"Fatura exclu\u00edda com sucesso","invoice_due_amount_retrieve_successfully":"Valor devido da fatura recuperado com sucesso","invoice_saved_and_sent_successfully":"Fatura salva e enviada com sucesso","invoice_saved_successfully":"Fatura salva com sucesso","invoice_template_updated_successfully":"Modelo de fatura atualizado com sucesso","invoice_updated_and_send_successfully":"Fatura atualizada e enviada com sucesso","invoice_updated_successfully":"Fatura atualizada com sucesso","language_updated_successfully":"Idioma atualizado com sucesso","manual_payment_approved_successfully":"Pagamento manual aprovado com sucesso","manual_payment_denied_successfully":"Pagamento manual negado com sucesso","note_retrieved_successfully":"Nota recuperada com sucesso","notification_read_successfully":"Notifica\u00e7\u00e3o lida com sucesso","number_of_days_for_recurring_cycle":"N\u00famero de dias para ciclo recorrente","password_updated_successfully":"Senha atualizada com sucesso","payment_deleted_successfully":"Pagamento exclu\u00eddo com sucesso.","payment_overview_status_retrieved_successfully":"Status PaymentOverview recuperado com sucesso","payment_qr_code_deleted_successfully":"C\u00f3digo QR de pagamento exclu\u00eddo com sucesso","payment_qr_code_saved_successfully":"C\u00f3digo QR de pagamento salvo com sucesso","payment_qr_code_status_updated_successfully":"Status do c\u00f3digo QR do pagamento atualizado com sucesso","payment_qr_code_updated_successfully":"C\u00f3digo QR de pagamento atualizado com sucesso","payment_reminder_mail_send_successfully":"E-mail de lembrete de pagamento enviado com sucesso","payment_saved_successfully":"Pagamento salvo com sucesso.","payment_updated_successfully":"Pagamento atualizado com sucesso.","product_cant_deleted":"O produto n\u00e3o pode ser exclu\u00eddo.","product_created_successfully":"Produto criado com sucesso","product_deleted_successfully":"Produto exclu\u00eddo com sucesso","product_price_retrieved_successfully":"Pre\u00e7o do produto recuperado com sucesso","product_updated_successfully":"Produto atualizado com sucesso","quote_deleted_successfully":"Cita\u00e7\u00e3o exclu\u00edda com sucesso","quote_saved_successfully":"Cota\u00e7\u00e3o salva com sucesso","quote_updated_successfully":"Cota\u00e7\u00e3o atualizada com sucesso","recurring_status_updated_successfully":"Status recorrente atualizado com sucesso","seems_you_are_not_allowed_to_access_this_record":"Parece que voc\u00ea n\u00e3o tem permiss\u00e3o para acessar este registro.","select_currency":"Escolha a moeda","select_payment_qr_code":"Selecionar c\u00f3digo QR de pagamento","select_product_or_enter_free_text":"Selecionar produto ou inserir texto livre","setting_updated_successfully":"Configura\u00e7\u00e3o atualizada com sucesso","status_retrieved_successfully":"Status recuperado com sucesso","status_updated_successfully":"Status atualizado com sucesso","tax_can_not_deleted":"O imposto n\u00e3o pode ser exclu\u00eddo.","tax_deleted_successfully":"Imposto exclu\u00eddo com sucesso","tax_retrieved_successfully":"Imposto recuperado com sucesso","tax_saved_successfully":"Imposto salvo com sucesso","tax_updated_successfully":"Imposto atualizado com sucesso","yearly_income_overview_chart_data_retrieved_successfully":"Dados do gr\u00e1fico de vis\u00e3o geral da renda anual recuperados com sucesso"},"general":"Geral","invoice":{"add":"Adicionar","add_note_term":"Adicionar nota e termos","amount":"Quantia","amount_should_be_less_than_payable_amount":"O valor deve ser menor que o valor a pagar.","are_you_sure_send":"Tem certeza de que deseja enviar esta fatura ao cliente?","client":"Cliente","client_email":"Email do cliente","client_name":"Nome do cliente","client_overview":"VIS\u00c3O GERAL DO CLIENTE","copy_invoice_url":"Copiar URL da fatura","discount":"Desconto","discount_type":"Tipo de Desconto","download":"Baixar","due_amount":"Valor devido","due_date":"Encontro de vencimento","edit_invoice":"Editar fatura","excel_export":"Exportar Excel","fax_no":"n\u00famero de fax","has_been_sent":"foi enviado.","invoice":"Fatura","invoice_date":"Data da fatura","invoice_details":"Detalhes da fatura","invoice_id":"ID da fatura","invoice_number":"N\u00famero da fatura","invoice_pdf":"Fatura","invoice_url":"URL da fatura","issue_by":"Emitido por","issue_for":"Problema para","last_recurring_on":"\u00daltimo Recorrente em","make_payment":"Fa\u00e7a o pagamento","new_invoice":"Nova fatura","note":"Nota","note_not_found":"Nota n\u00e3o encontrada","note_terms":"Nota e Termos","nothing_amount_yet":"Nada soma ainda.","nothing_due_yet":"Nada devido ainda.","nothing_paid_yet":"Nada pago ainda.","overview":"Vis\u00e3o geral","paid":"Pago","paid_amount":"Montante pago","parent_invoice":"Fatura principal","payment":"Pagamento","payment_history":"Hist\u00f3rico de pagamentos","payment_method":"M\u00e9todo de pagamento","payment_reminder_mail":"E-mail de lembrete de pagamento","price":"Pre\u00e7o","print_invoice":"Imprimir fatura","qty":"Qtde","recurring":"Recorrente","recurring_cycle":"Ciclo recorrente","recurring_invoices":"Faturas recorrentes","remaining_amount":"Montante Restante","remove_note_term":"Remover Nota e Termos","send":"Enviar","send_invoice":"Enviar fatura","start_recurring":"come\u00e7ar recorrente","stop_recurring":"parar de repetir","sub_total":"Subtotal","tax":"Imposto","terms":"Termos","terms_not_found":"Termos n\u00e3o encontrados","total":"Total","total_tax":"Imposto","transactions":"Transa\u00e7\u00f5es","yes_send":"Sim, enviar"},"invoice_templates":"Modelos de fatura","invoices":"Faturas","item":"Item","language":"Idioma","login":{"email":"E-mail","forget_your_password":"Esqueceu sua senha?","login":"Conecte-se","password":"Senha","remember_me":"Lembre de mim","sign_in":"Entrar"},"months":{"apr":"abril","aug":"agosto","dec":"dezembro","feb":"fevereiro","jan":"janeiro","jul":"julho","jun":"junho","mar":"mar\u00e7o","may":"Poderia","nov":"novembro","oct":"Outubro","sep":"setembro"},"no_records_found":"Nenhum registro foi encontrado.","notification":{"mark_all_as_read":"Marcar todos como lidos","notifications":"Notifica\u00e7\u00f5es","you_don`t_have_any_new_notification":"Voc\u00ea n\u00e3o tem nenhuma nova notifica\u00e7\u00e3o"},"paid_invoices":"Faturas Pagas","payment":{"add_payment":"Adicionar pagamento","edit_payment":"Editar pagamento","payable_amount":"Montante a pagar","payment_amount":"Valor do pagamento","payment_date":"Encontro de pagamento","payment_method":"Forma de pagamento","payment_mode":"Modo de pagamento","payment_type":"Tipo de pagamento","transaction_id":"Id da transa\u00e7\u00e3o","transaction_notes":"Notas de transa\u00e7\u00e3o"},"payment-gateway":"Gateway de pagamento","payment_qr_codes":{"action":"A\u00e7\u00e3o","add_qr":"Adicionar Qr","add_qr_code":"Adicionar c\u00f3digo QR","default":"Padr\u00e3o","edit_qr_code":"Editar c\u00f3digo QR","payment_qr_code":"C\u00f3digo QR de pagamento","payment_qr_codes":"C\u00f3digos QR de pagamento","qr_code":"C\u00f3digo QR","qr_image":"Imagem QR","title":"T\u00edtulo"},"payments":"Pagamentos","pdf_export":"Exporta\u00e7\u00e3o de PDF","placeholder":{"invalid_country_number":"N\u00famero de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","select_tax":"Selecionar imposto","too_long":"Demasiado longo","too_short":"Muito curto","valid_number":"N\u00famero v\u00e1lido"},"product":{"add_product":"Adicionar produto","category":"Categoria","code":"C\u00f3digo do produto","description":"Descri\u00e7\u00e3o","edit_product":"Editar Produto","image":"Imagem","name":"Nome","price":"Pre\u00e7o","product":"Produto","product_details":"Detalhes do produto","product_name":"Nome do produto","unit_price":"Pre\u00e7o unit\u00e1rio","updated_at":"Atualizado em"},"products":"Produtos","quote":{"add":"Adicionar","add_note_term":"Adicionar nota e termos","amount":"Quantia","client":"Cliente","client_email":"Email do cliente","client_id_required":"A Data de Vencimento da Cota\u00e7\u00e3o \u00e9 obrigat\u00f3ria.","client_name":"Nome do cliente","client_overview":"VIS\u00c3O GERAL DO CLIENTE","convert_to_invoice":"Converter em fatura","discount":"Desconto","discount_type":"Tipo de Desconto","download":"Baixar","due_amount":"Valor devido","due_date":"Encontro de vencimento","edit_quote":"Editar cota\u00e7\u00e3o","excel_export":"Exportar Excel","issue_by":"Emitido por","issue_for":"Problema para","make_payment":"Fa\u00e7a o pagamento","new_quote":"Nova cota\u00e7\u00e3o","note":"Nota","note_not_found":"Nota n\u00e3o encontrada","note_terms":"Nota e Termos","overview":"Vis\u00e3o geral","paid":"Pago","paid_amount":"Montante pago","payment":"Pagamento","payment_history":"Hist\u00f3rico de pagamentos","payment_method":"M\u00e9todo de pagamento","price":"Pre\u00e7o","print_quote":"Imprimir cota\u00e7\u00e3o","qty":"Qtde","quote":"cota\u00e7\u00e3o","quote_date":"Data da cota\u00e7\u00e3o","quote_details":"Detalhes da cota\u00e7\u00e3o","quote_id":"ID da cota\u00e7\u00e3o","quote_name":"Citar","quote_number":"N\u00famero da cota\u00e7\u00e3o","quote_pdf":"Cota\u00e7\u00e3o","quote_url":"URL de cota\u00e7\u00e3o","recurring":"Recorrente","remaining_amount":"Montante Restante","remove_note_term":"Remover Nota e Termos","sub_total":"Subtotal","tax":"Imposto","terms":"Termos","terms_not_found":"Termos n\u00e3o encontrados","total":"Total","total_tax":"Imposto","transactions":"Transa\u00e7\u00f5es"},"quotes":"Cita\u00e7\u00f5es","received_amount":"Valor recebido","registered_date":"Data de registro","roles":"Fun\u00e7\u00f5es","setting":{"address":"Endere\u00e7o","app_logo":"Logotipo do aplicativo","app_name":"Nome do aplicativo","auto_approve":"Aprova\u00e7\u00e3o autom\u00e1tica","clinic_name":"Nome da cl\u00ednica","color":"Color","company_address":"Endere\u00e7o da empresa","company_image_validation":"A imagem deve ser de pixel 210 x 50.","company_logo":"Logotipo da empresa","company_name":"Nome da empresa","company_phone":"Telefone da empresa","contact_information":"Informa\u00e7\u00f5es de contato","country_code":"C\u00f3digo do pa\u00eds","currencies":"Moedas","currency_position":"Posi\u00e7\u00e3o da moeda","currency_settings":"Configura\u00e7\u00f5es de moeda","date_format":"Formato de data","decimal_separator":"Separador decimal","fav_icon":"Favicon","general":"Geral","general_details":"Detalhes gerais","image_validation":"A imagem deve ter pixel 90 x 60.","invoice_no_prefix":"Fatura sem prefixo","invoice_no_suffix":"Fatura sem sufixo","invoice_settings":"Configura\u00e7\u00f5es de fatura","invoice_template":"Modelo de fatura","mail_notifications":"Notifica\u00e7\u00f5es de correio","manual_payment_approval":"Aprova\u00e7\u00e3o de pagamento manual","payment_approved":"Pagamento aprovado","payment_auto_approved":"Aprova\u00e7\u00e3o autom\u00e1tica de pagamento","paypal":"PayPal","paypal_client_id":"ID do cliente Paypal","paypal_secret":"Segredo do Paypal","postal_code":"C\u00f3digo postal","prefix":"Prefixo","razorpay":"Razorpay","razorpay_key":"Chave Razorpay","razorpay_secret":"Segredo Razorpay","send_due_invoice_email_before_x_days":"Enviar e-mail de fatura vencida antes de X dias","setting":"Configura\u00e7\u00e3o","show_additional_address":"Mostrar endere\u00e7o adicional na fatura","show_currency_behind":"Mostrar moeda atr\u00e1s","show_product_description":"Mostrar descri\u00e7\u00e3o do produto","specialities":"Especialidades","stripe":"Listra","stripe_key":"Chave de faixa","stripe_secret":"Segredo da Faixa","thousand_separator":"Thousand Separator","time_format":"Formato de hora","timezone":"Fuso Hor\u00e1rio"},"settings":"Configura\u00e7\u00f5es","sign_out":"Sair","states":"Estados","tax":{"add_tax":"Adicionar imposto","edit_tax":"Editar imposto","is_default":"\u00c9 o padr\u00e3o","no":"N\u00e3o","tax":"Imposto","yes":"Sim"},"tax_information":"Informa\u00e7\u00e3o de impostos","taxes":"Impostos","transactions":"Transa\u00e7\u00f5es","unpaid_invoices":"Faturas n\u00e3o pagas","user":{"account":"Conta","account_setting":"Configura\u00e7\u00f5es da conta","avatar":"Avatar","change_password":"Alterar senha","confirm_password":"Confirmar senha","contact_number":"N\u00famero do contato","current_password":"Senha atual","email":"Email","full_name":"Nome Completo","gender":"Sexo","new_password":"Nova senha","phone":"Telefone","phone_number":"N\u00famero de Telefone","profile":"Perfil","profile_details":"Detalhes do perfil","save_changes":"Salvar altera\u00e7\u00f5es","setting":"Configura\u00e7\u00e3o","user_details":"Detalhes do usu\u00e1rio"},"users":"Comercial","weekdays":{"fri":"SEX","mon":"SEG","sat":"Sentado","sun":"SOL","thu":"QUI","tue":"TER","wed":"QUA"}},"ru.messages":{"add_admin":"\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","admin":"\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440","admin_dashboard":{"dashboard":"\u041f\u0430\u043d\u0435\u043b\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432","day":"\u0414\u0435\u043d\u044c","income_overview":"\u041e\u0431\u0437\u043e\u0440 \u0441\u0447\u0435\u0442\u043e\u0432","invoice_overview":"\u041e\u0431\u0437\u043e\u0440 \u0441\u0447\u0435\u0442\u043e\u0432","month":"\u041c\u0435\u0441\u044f\u0446","monthly_income_overview":"\u041e\u0431\u0437\u043e\u0440 \u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e\u0433\u043e \u0434\u043e\u0445\u043e\u0434\u0430","name":"\u0418\u041c\u042f","no_record_found":"\u0417\u0430\u043f\u0438\u0441\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","payment_overview":"\u041e\u0431\u0437\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439","registered":"\u0417\u0410\u0420\u0415\u0413\u0418\u0421\u0422\u0420\u0418\u0420\u041e\u0412\u0410\u041d\u041e","total_amount":"\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430","total_clients":"\u0412\u0441\u0435\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432","total_due":"\u0418\u0442\u043e\u0433\u043e \u043a \u043e\u043f\u043b\u0430\u0442\u0435","total_invoices":"\u0412\u0441\u0435\u0433\u043e \u0441\u0447\u0435\u0442\u043e\u0432","total_overdue_invoice":"\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u043e\u0432","total_paid":"\u0412\u0441\u0435\u0433\u043e \u0432\u044b\u043f\u043b\u0430\u0447\u0435\u043d\u043e","total_paid_invoices":"\u0412\u0441\u0435\u0433\u043e \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u043e\u0432","total_partial_paid_invoices":"\u0412\u0441\u0435\u0433\u043e \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u043e\u0432","total_payments":"\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439","total_products":"\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432","total_unpaid_invoices":"\u0412\u0441\u0435\u0433\u043e \u043d\u0435\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u043e\u0432","week":"\u041d\u0435\u0434\u0435\u043b\u044f","year":"\u0433\u043e\u0434","yearly_income_overview":"\u041e\u0431\u0437\u043e\u0440 \u0433\u043e\u0434\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0445\u043e\u0434\u0430"},"admin_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0435","admins":"\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u044b","apps":"\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","categories":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438","category":{"add_category":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","edit_category":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e"},"change_avatar":"\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0432\u0430\u0442\u0430\u0440","change_language":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044f\u0437\u044b\u043a","cities":"\u0413\u043e\u0440\u043e\u0434\u0430","clear_cache":"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043a\u044d\u0448","client":{"add_client":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0430","add_user":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","address":"\u0410\u0434\u0440\u0435\u0441","city":"\u0413\u043e\u0440\u043e\u0434","client":"\u041a\u043b\u0438\u0435\u043d\u0442","client_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0435","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_no":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","country":"\u0421\u0442\u0440\u0430\u043d\u0430","created_at":"\u0414\u0430\u0442\u0430","edit_user":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","first_name":"\u0418\u043c\u044f","gender":"\u041f\u043e\u043b","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","male":"\u041c\u0443\u0436\u0441\u043a\u043e\u0439","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435","notes":"\u0417\u0430\u043c\u0435\u0442\u043a\u0438","password":"\u041f\u0430\u0440\u043e\u043b\u044c","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","role":"\u0440\u043e\u043b\u044c","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","website":"\u0412\u0435\u0431-\u0441\u0430\u0439\u0442"},"client_address":"\u0410\u0434\u0440\u0435\u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u0430","clients":"\u041a\u043b\u0438\u0435\u043d\u0442\u044b","common":{"action":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435","actions":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f","active":"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439","add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c","address":"\u0410\u0434\u0440\u0435\u0441","allow_file_type":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432","apply":"\u041f\u043e\u0434\u0430\u0442\u044c \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u0435","are_you_sure_delete":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","attachment":"\u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435","back":"\u041d\u0430\u0437\u0430\u0434","cancel":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","city":"\u0413\u043e\u0440\u043e\u0434","click_here":"\u041a\u043b\u0438\u043a\u043d\u0438\u0442\u0435 \u0441\u044e\u0434\u0430","country":"\u0421\u0442\u0440\u0430\u043d\u0430","created_at":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","de_active":"\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d","default":"\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0443\u0434\u0430\u043b\u0435\u043d!","details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438","discard":"\u041e\u0442\u0431\u0440\u043e\u0441\u0438\u0442\u044c","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","error":"\u041e\u0448\u0438\u0431\u043a\u0430","filter":"\u0424\u0438\u043b\u044c\u0442\u0440","filter_options":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0438\u043b\u044c\u0442\u0440\u0430","from":"\u0418\u0437","has_been_deleted":"\u043e\u043d \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","invoice":"\u0421\u0427\u0415\u0422","last_update":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435","mo":"\u041c\u043e","n\/a":"\u043d \/ \u0434","name":"\u0418\u043c\u044f","no_cancel":"\u043d\u0435\u0442, \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","ok":"\u0425\u041e\u0420\u041e\u0428\u0418\u0419","pay":"\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c","payment_type":"\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430","please_wait":"\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 ...","quote_name":"\u0426\u0438\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","regards":"\u0421 \u0443\u0432\u0430\u0436\u0435\u043d\u0438\u0435\u043c","reminder":"\u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435","reset":"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c","save":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c","save_draft":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u0430\u043a \u0447\u0435\u0440\u043d\u043e\u0432\u0438\u043a","save_send":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c","search":"\u041f\u043e\u0438\u0441\u043a","service":"\u0421\u0435\u0440\u0432\u0438\u0441","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","status":"\u0421\u0442\u0430\u0442\u0443\u0441","submit":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c","to":"\u041a","updated_at":"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e","value":"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435","yes_delete":"\u0434\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","zipcode":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441"},"countries":"\u0421\u0442\u0440\u0430\u043d\u044b","currency":{"add_currency":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443","currency":"\u0432\u0430\u043b\u044e\u0442\u044b","currency_code":"\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b","edit_currency":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443","icon":"\u0417\u043d\u0430\u0447\u043e\u043a"},"currency_reports":"\u0412\u0430\u043b\u044e\u0442\u043d\u044b\u0435 \u043e\u0442\u0447\u0435\u0442\u044b","dashboard":"\u041f\u0430\u043d\u0435\u043b\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432","datepicker":{"custom":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_7_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7 \u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","last_week":"\u041f\u0440\u043e\u0448\u043b\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","yesterday":"\u0412\u0447\u0435\u0440\u0430"},"edit_admin":"\u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","flash":{"Admin_cant_be_deleted":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c","Admin_deleted_successfully":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","Invoice_send_successfully":"\u0421\u0447\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d","admin_created_successfully":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","admin_profile_updated_successfully":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","admin_updated_successfully":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","all_notification_read_successfully":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e","allowed_file_types_png_jpg_jpeg":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","application_cache_cleared":"\u041a\u044d\u0448 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0447\u0438\u0449\u0435\u043d!","are_sure_want_to_delete_this_client_related_all_invoices":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u0447\u0435\u0442\u0430, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u044d\u0442\u0438\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c ?","category_cant_deleted":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","category_deleted_successfully":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430","category_retrieved_successfully":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e","category_saved_successfully":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430","category_updated_successfully":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","cities_retrieved_successfully":"\u0413\u043e\u0440\u043e\u0434\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b","click_refresh_icon_generate_product_code":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u043e\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f, \u0447\u0442\u043e\u0431\u044b \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","client_cant_deleted":"\u041a\u043b\u0438\u0435\u043d\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d.","client_created_successfully":"\u041a\u043b\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","client_deleted_successfully":"\u041a\u043b\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","client_updated_successfully":"\u041a\u043b\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","converted_quote_can_not_editable":"\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0446\u0438\u0442\u0430\u0442\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f","converted_to_invoice_successfully":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u043e \u0432 \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","currency_cant_deleted":"\u042d\u0442\u0430 \u0432\u0430\u043b\u044e\u0442\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","currency_deleted_successfully":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430","currency_saved_successfully":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430.","currency_updated_successfully":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","current_password_is_invalid":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d","default_admin_can_not_editable":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d","invoice_currency_retrieved_successfully":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0441\u0447\u0435\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430","invoice_deleted_successfully":"\u0421\u0447\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","invoice_due_amount_retrieve_successfully":"\u0421\u0443\u043c\u043c\u0430 \u0441\u0447\u0435\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430","invoice_saved_and_sent_successfully":"\u0421\u0447\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d","invoice_saved_successfully":"\u0421\u0447\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d","invoice_template_updated_successfully":"\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0447\u0435\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","invoice_updated_and_send_successfully":"\u0421\u0447\u0435\u0442 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d","invoice_updated_successfully":"\u0421\u0447\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","language_updated_successfully":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","manual_payment_approved_successfully":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043e\u0434\u043e\u0431\u0440\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e","manual_payment_denied_successfully":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e","note_retrieved_successfully":"\u0417\u0430\u043c\u0435\u0442\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430","notification_read_successfully":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e","number_of_days_for_recurring_cycle":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0435\u0433\u043e\u0441\u044f \u0446\u0438\u043a\u043b\u0430","password_updated_successfully":"\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","payment_deleted_successfully":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","payment_overview_status_retrieved_successfully":"\u0421\u0442\u0430\u0442\u0443\u0441 PaymentOverview \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d","payment_qr_code_deleted_successfully":"QR-\u043a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","payment_qr_code_saved_successfully":"QR-\u043a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d","payment_qr_code_status_updated_successfully":"\u0421\u0442\u0430\u0442\u0443\u0441 qr-\u043a\u043e\u0434\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","payment_qr_code_updated_successfully":"QR-\u043a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","payment_reminder_mail_send_successfully":"\u041f\u0438\u0441\u044c\u043c\u043e \u0441 \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435\u043c \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e","payment_saved_successfully":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.","payment_updated_successfully":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","product_cant_deleted":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d.","product_created_successfully":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","product_deleted_successfully":"\u0422\u043e\u0432\u0430\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","product_price_retrieved_successfully":"\u0426\u0435\u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430","product_updated_successfully":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","quote_deleted_successfully":"\u0426\u0438\u0442\u0430\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430","quote_saved_successfully":"\u0426\u0438\u0442\u0430\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430","quote_updated_successfully":"\u0426\u0438\u0442\u0430\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","recurring_status_updated_successfully":"\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","seems_you_are_not_allowed_to_access_this_record":"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u044d\u0442\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438.","select_currency":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u043b\u044e\u0442\u0443","select_payment_qr_code":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 QR-\u043a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","select_product_or_enter_free_text":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0438\u043b\u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442","setting_updated_successfully":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b","status_retrieved_successfully":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d","status_updated_successfully":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","tax_can_not_deleted":"\u041d\u0430\u043b\u043e\u0433 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c.","tax_deleted_successfully":"\u041d\u0430\u043b\u043e\u0433 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","tax_retrieved_successfully":"\u041d\u0430\u043b\u043e\u0433 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e","tax_saved_successfully":"\u041d\u0430\u043b\u043e\u0433 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d","tax_updated_successfully":"\u041d\u0430\u043b\u043e\u0433 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","yearly_income_overview_chart_data_retrieved_successfully":"\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b \u0433\u043e\u0434\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0445\u043e\u0434\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b"},"general":"\u041e\u0431\u0449\u0438\u0435","invoice":{"Discount":"\u0421\u043a\u0438\u0434\u043a\u0430","Discount_type":"\u0422\u0438\u043f \u0441\u043a\u0438\u0434\u043a\u0438","Payment_reminder_mail":"\u041f\u0438\u0441\u044c\u043c\u043e \u0441 \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435\u043c \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435","Remaining_amount":"\u041e\u0441\u0442\u0430\u0432\u0448\u0430\u044f\u0441\u044f \u0441\u0443\u043c\u043c\u0430","add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c","add_note_term":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","amount":"\u0421\u0443\u043c\u043c\u0430","amount_should_be_less_than_payable_amount":"\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u043a \u043e\u043f\u043b\u0430\u0442\u0435.","are_you_sure_send":"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0443?","client":"\u041a\u043b\u0438\u0435\u043d\u0442","client_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430","client_name":"\u0418\u043c\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430","client_overview":"\u041e\u0411\u0417\u041e\u0420 \u041a\u041b\u0418\u0415\u041d\u0422\u0410","copy_invoice_url":"\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c URL-\u0430\u0434\u0440\u0435\u0441 \u0441\u0447\u0435\u0442\u0430","download":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c","due_amount":"\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435","due_date":"\u0421\u0440\u043e\u043a \u0441\u0434\u0430\u0447\u0438","edit_invoice":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","excel_export":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 Excel","fax_no":"\u041d\u043e\u043c\u0435\u0440 \u0444\u0430\u043a\u0441\u0430","has_been_sent":"\u0431\u044b\u043b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d.","invoice":"\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430","invoice_date":"\u0414\u0430\u0442\u0430 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430","invoice_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0441\u0447\u0435\u0442\u0430","invoice_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0447\u0435\u0442\u0430","invoice_number":"\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430","invoice_pdf":"\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430","invoice_url":"\u0430\u0434\u0440\u0435\u0441 \u0441\u0447\u0435\u0442\u0430","issue_by":"\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d","issue_for":"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0434\u043b\u044f","last_recurring_on":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0438\u0435","make_payment":"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u0443","new_invoice":"\u041d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435","note_not_found":"\u0417\u0430\u043c\u0435\u0442\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","note_terms":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","nothing_amount_yet":"\u041f\u043e\u043a\u0430 \u043d\u0438\u0447\u0435\u0433\u043e.","nothing_due_yet":"\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0435\u0449\u0435.","nothing_paid_yet":"\u0415\u0449\u0435 \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043e.","overview":"\u041e\u0431\u0437\u043e\u0440","paid":"\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043e","parent_invoice":"\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442","pay_amount":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","payment_history":"\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439","payment_method":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","price":"\u0426\u0435\u043d\u0430","print_invoice":"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","qty":"\u041a\u043e\u043b-\u0432\u043e","recurring":"\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f","recurring_cycle":"\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u0446\u0438\u043a\u043b","recurring_invoices":"\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u0441\u0447\u0435\u0442\u0430","remove_note_term":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","send":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c","send_invoice":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442","start_recurring":"\u043d\u0430\u0447\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0442\u044c\u0441\u044f","stop_recurring":"\u0445\u0432\u0430\u0442\u0438\u0442 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0442\u044c","sub_total":"\u041f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u044b\u0439 \u0438\u0442\u043e\u0433","tax":"\u041d\u0430\u043b\u043e\u0433","terms":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f","terms_not_found":"\u0422\u0435\u0440\u043c\u0438\u043d\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b","total":"\u0418\u0442\u043e\u0433\u043e","total_tax":"\u041d\u0430\u043b\u043e\u0433","transactions":"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438","yes_send":"\u0414\u0430, \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c"},"invoice_templates":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0441\u0447\u0435\u0442\u043e\u0432","invoices":"\u0421\u0447\u0435\u0442\u0430","item":"\u042d\u043b\u0435\u043c\u0435\u043d\u0442","language":"\u042f\u0437\u044b\u043a","login":{"email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","forget_your_password":"\u0417\u0430\u0431\u044b\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c?","login":"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f","password":"\u041f\u0430\u0440\u043e\u043b\u044c","remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044f","sign_in":"\u0412\u043e\u0439\u0442\u0438"},"months":{"apr":"\u0430\u043f\u0440","aug":"\u0430\u0432\u0433","dec":"\u0434\u0435\u043a\u0430\u0431\u0440\u044c","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","jan":"\u042f\u043d","jul":"\u0438\u044e\u043b\u044c","jun":"\u0438\u044e\u043d\u044c","mar":"\u043c\u0430\u0440\u0442","may":"\u041c\u0430\u0439","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u043e\u043a\u0442\u044f\u0431\u0440\u044c","sep":"\u0441\u0435\u043d"},"no_records_found":"\u0417\u0430\u043f\u0438\u0441\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.","notification":{"mark_all_as_read":"\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0435","notifications":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f","you_don`t_have_any_new_notification":"\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439"},"paid_invoices":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0430","payment":{"add_payment":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436","edit_payment":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436","payable_amount":"\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435","payment_amount":"\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_date":"\u0414\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_method":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","payment_mode":"\u0420\u0435\u0436\u0438\u043c \u043e\u043f\u043b\u0430\u0442\u044b","payment_type":"\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430","transaction_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438","transaction_notes":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f \u043a \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f\u043c"},"payment-gateway":"\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437","payment_qr_codes":{"action":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435","add_qr":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c Qr","add_qr_code":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c QR-\u043a\u043e\u0434","default":"\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","edit_qr_code":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c QR-\u043a\u043e\u0434","payment_qr_code":"\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 QR-\u043a\u043e\u0434","payment_qr_codes":"\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0435 QR-\u043a\u043e\u0434\u044b","qr_code":"QR \u043a\u043e\u0434","qr_image":"QR-\u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"payments":"\u041f\u043b\u0430\u0442\u0435\u0436\u0438","pdf_export":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442 PDF","placeholder":{"invalid_country_number":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","select_tax":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043b\u043e\u0433","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","valid_number":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440"},"product":{"add_product":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","code":"\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","edit_product":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442","image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","name":"\u0418\u043c\u044f","price":"\u0426\u0435\u043d\u0430","product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442","product_details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0435","product_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","unit_price":"\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443","updated_at":"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0432"},"products":"\u0422\u043e\u0432\u0430\u0440\u044b","quote":{"Discount":"\u0421\u043a\u0438\u0434\u043a\u0430","Remaining_amount":"\u041e\u0441\u0442\u0430\u0432\u0448\u0430\u044f\u0441\u044f \u0441\u0443\u043c\u043c\u0430","add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c","add_note_term":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","amount":"\u0421\u0443\u043c\u043c\u0430","client":"\u041a\u043b\u0438\u0435\u043d\u0442","client_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430","client_id_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430.","client_name":"\u0418\u043c\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430","client_overview":"\u041e\u0411\u0417\u041e\u0420 \u041a\u041b\u0418\u0415\u041d\u0422\u0410","convert_to_invoice":"\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","discount":"\u0421\u043a\u0438\u0434\u043a\u0430","discount_type":"\u0422\u0438\u043f \u0441\u043a\u0438\u0434\u043a\u0438","download":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c","due_amount":"\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435","due_date":"\u0421\u0440\u043e\u043a \u0441\u0434\u0430\u0447\u0438","edit_quote":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0446\u0438\u0442\u0430\u0442\u0443","excel_export":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 Excel","issue_by":"\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d","issue_for":"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0434\u043b\u044f","make_payment":"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u0443","new_quote":"\u041d\u043e\u0432\u0430\u044f \u0446\u0438\u0442\u0430\u0442\u0430","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435","note_not_found":"\u0417\u0430\u043c\u0435\u0442\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","note_terms":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","overview":"\u041e\u0431\u0437\u043e\u0440","paid":"\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043e","pay_amount":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","payment_history":"\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439","payment_method":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","price":"\u0426\u0435\u043d\u0430","print_quote":"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0446\u0438\u0442\u0430\u0442\u0443","qty":"\u041a\u043e\u043b-\u0432\u043e","quote":"\u0426\u0438\u0442\u0430\u0442\u0430","quote_date":"\u0414\u0430\u0442\u0430 \u043a\u043e\u0442\u0438\u0440\u043e\u0432\u043a\u0438","quote_details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0446\u0438\u0442\u0430\u0442\u044b","quote_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0446\u0438\u0442\u0430\u0442\u044b","quote_number":"\u041d\u043e\u043c\u0435\u0440 \u043a\u043e\u0442\u0438\u0440\u043e\u0432\u043a\u0438","quote_pdf":"\u0426\u0438\u0442\u0430\u0442\u0430","quote_url":"\u0426\u0438\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c URL","recurring":"\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f","remove_note_term":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f","sub_total":"\u041f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u044b\u0439 \u0438\u0442\u043e\u0433","tax":"\u041d\u0430\u043b\u043e\u0433","terms":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f","terms_not_found":"\u0422\u0435\u0440\u043c\u0438\u043d\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b","total":"\u0418\u0442\u043e\u0433\u043e","total_tax":"\u041d\u0430\u043b\u043e\u0433","transactions":"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"},"quotes":"\u041a\u043e\u0442\u0438\u0440\u043e\u0432\u043a\u0438","received_amount":"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430","registered_date":"\u0414\u0430\u0442\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438","roles":"\u0420\u043e\u043b\u0438","setting":{"address":"\u0410\u0434\u0440\u0435\u0441","app_logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","app_name":"\u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","auto_approve":"\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0434\u043e\u0431\u0440\u0435\u043d\u0438\u0435","clinic_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u043d\u0438\u043a\u0438","color":"\u0426\u0432\u0435\u0442","company_address":"\u0410\u0434\u0440\u0435\u0441 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","company_image_validation":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 210 x 50 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439.","company_logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","company_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","company_phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","contact_information":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","country_code":"\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","currencies":"\u0412\u0430\u043b\u044e\u0442\u044b","currency_position":"\u0412\u0430\u043b\u044e\u0442\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f","currency_settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u0430\u043b\u044e\u0442\u044b","date_format":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b","decimal_separator":"\u0414\u0435\u0441\u044f\u0442\u0438\u0447\u043d\u044b\u0439 \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c","fav_icon":"\u0424\u0430\u0432\u0438\u043a\u043e\u043d","general":"\u041e\u0431\u0449\u0438\u0435","general_details":"\u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f","image_validation":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 90 x 60 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439.","invoice_no_prefix":"\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430 \u0431\u0435\u0437 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0430","invoice_no_suffix":"\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430 \u0431\u0435\u0437 \u0441\u0443\u0444\u0444\u0438\u043a\u0441\u0430","invoice_settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0447\u0435\u0442\u0430","invoice_template":"\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0447\u0435\u0442\u0430","mail_notifications":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f","manual_payment_approval":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432\u0440\u0443\u0447\u043d\u0443\u044e","payment_approved":"\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0434\u043e\u0431\u0440\u0435\u043d","payment_auto_approved":"\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0434\u043e\u0431\u0440\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","paypal":"PayPal","paypal_client_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 Paypal","paypal_secret":"\u041f\u0430\u0439\u041f\u0430\u043b \u0421\u0435\u043a\u0440\u0435\u0442","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441","prefix":"\u041f\u0440\u0435\u0444\u0438\u043a\u0441","razorpay":"Razorpay","razorpay_key":"\u041a\u043b\u044e\u0447 Razorpay","razorpay_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 Razorpay","send_due_invoice_email_before_x_days":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u0441\u043e \u0441\u0447\u0435\u0442\u043e\u043c \u0434\u043e X \u0434\u043d\u0435\u0439","setting":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430","show_additional_address":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0432 \u0441\u0447\u0435\u0442\u0435","show_currency_behind":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 \u043f\u043e\u0437\u0430\u0434\u0438","show_product_description":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","specialties":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","stripe":"\u0413\u0440\u0443\u043f\u043f\u0430","stripe_key":"\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u043a\u043b\u044e\u0447","stripe_secret":"\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u0441\u0435\u043a\u0440\u0435\u0442","thousand_separator":" \u0420\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u0442\u044b\u0441\u044f\u0447 ","time_format":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438","timezone":"\u0427\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441"},"settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438","sign_out":"\u0412\u044b\u0439\u0442\u0438","states":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f","tax":{"add_tax":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0430\u043b\u043e\u0433","edit_tax":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u043b\u043e\u0433","is_default":"\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","no":"\u041d\u0435\u0442","tax":"\u041d\u0430\u043b\u043e\u0433","yes":"\u0414\u0430"},"tax_information":"\u041d\u0430\u043b\u043e\u0433\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","taxes":"\u041d\u0430\u043b\u043e\u0433\u0438","transactions":"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438","unpaid_invoices":"\u041d\u0435\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0430","user":{"account":"\u0410\u043a\u043a\u0430\u0443\u043d\u0442","account_setting":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438","avatar":"\u0410\u0432\u0430\u0442\u0430\u0440","change_password":"\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c","contact_number":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","current_password":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","gender":"\u041f\u043e\u043b","new_password":"\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","phone_number":"\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","profile_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044f","save_changes":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f","setting":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430","user_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435"},"users":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438","weekdays":{"fri":"\u041f\u0422","mon":"\u041f\u041d","sat":"\u0421\u0438\u0434\u0435\u043b","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","thu":"\u0427\u0422","tue":"\u0412\u0422","wed":"\u041c\u042b \u0411"}},"tr.messages":{"add_admin":"y\u00f6netici ekle","admin":"y\u00f6netici","admin_dashboard":{"dashboard":"G\u00f6sterge tablosu","day":"G\u00fcn","income_overview":"Gelire Genel Bak\u0131\u015f","invoice_overview":"Faturalara Genel Bak\u0131\u015f","month":"Ay","monthly_income_overview":"Ayl\u0131k Gelire Genel Bak\u0131\u015f","name":"\u0130S\u0130M","no_record_found":"Kay\u0131t Bulunamad\u0131","payment_overview":"\u00d6demeye Genel Bak\u0131\u015f","registered":"KAYITLI","total_amount":"Toplam Tutar","total_clients":"Toplam M\u00fc\u015fteri","total_due":"Toplam Bor\u00e7","total_invoices":"Toplam Faturalar","total_overdue_invoice":"Toplam Gecikmi\u015f Faturalar","total_paid":"Toplam \u00d6denen","total_paid_invoices":"Toplam \u00d6denen Faturalar","total_partial_paid_invoices":"Toplam K\u0131smen \u00d6denen Faturalar","total_payments":"Toplam \u00d6demeler","total_products":"Toplam \u00dcr\u00fcnler","total_unpaid_invoices":"Toplam \u00d6denmemi\u015f Faturalar","week":"Hafta","year":"y\u0131l","yearly_income_overview":"Y\u0131ll\u0131k Gelire Genel Bak\u0131\u015f"},"admin_details":"Y\u00f6netici Ayr\u0131nt\u0131lar\u0131","admins":"y\u00f6neticiler","apps":"Uygulamalar","categories":"Kategoriler","category":{"add_category":"Kategori Ekle","category":"Kategori","edit_category":"Kategoriyi D\u00fczenle"},"change_avatar":"awatary \u00e7aly\u015f","change_language":"Dili de\u011fi\u015ftir","cities":"\u015eehirler","clear_cache":"\u00d6nbelle\u011fi temizle","client":{"add_client":"M\u00fc\u015fteri Ekle","add_user":"Kullan\u0131c\u0131 Ekle","address":"Adres","city":"\u015eehir","client":"M\u00fc\u015fteri","client_details":"M\u00fc\u015fteri Ayr\u0131nt\u0131lar\u0131","confirm_password":"\u015eifreyi Onayla","contact_no":"\u0130leti\u015fim No","country":"\u00dclke","created_at":"Tarih","edit_user":"Kullan\u0131c\u0131y\u0131 D\u00fczenle","email":"E-posta","female":"Kad\u0131n","first_name":"\u0130lk ad\u0131","gender":"Cinsiyet","last_name":"Soyad\u0131","male":"Erkek","note":"Not","notes":"Notlar","password":"\u015eifre","postal_code":"Posta Kodu","profile":"Profil","role":"rol","state":"Devlet","website":"Web sitesi"},"client_address":"M\u00fc\u015fderini\u0148 salgysy","clients":"M\u00fc\u015fteriler","common":{"action":"Eylem","actions":"Eylemler","active":"Etkin","add":"Ekle","address":"Adres","allow_file_type":"\u0130zin verilen dosya t\u00fcrleri","apply":"Uygulamak","are_you_sure_delete":"Bunu silmek istedi\u011finizden emin misiniz","attachment":"ek","back":"Geri","cancel":"\u0130ptal","city":"\u015eehir","click_here":"Buraya t\u0131klay\u0131n","country":"\u00dclke","created_at":"Olu\u015fturuldu","custom":"Gelenek","de_active":"Devre d\u0131\u015f\u0131","default":"Varsay\u0131lan","delete":"silmek","deleted":"silindi!","details":"Ayr\u0131nt\u0131lar","discard":"At","edit":"D\u00fczenle","email":"E-posta","error":"Hata","filter":"Filtre","filter_options":"Filtre Se\u00e7enekleri","from":"\u0130tibaren","has_been_deleted":"silindi.","invoice":"FATURA","last_update":"Son G\u00fcncelleme","mo":"ay","n\/a":"Yok","name":"Ad","no_cancel":"hay\u0131r, iptal et","ok":"TAMAM","pay":"\u00d6de","payment_type":"\u00d6deme T\u00fcr\u00fc","please_wait":"L\u00fctfen bekleyin...","regards":"Sayg\u0131lar\u0131m\u0131zla","reminder":"hat\u0131rlatma","reset":"S\u0131f\u0131rla","save":"Kaydet","save_draft":"Taslak Olarak Kaydet","save_send":"Kaydet ve G\u00f6nder","search":"Arama","service":"Hizmet","state":"Devlet","status":"Durum","submit":"G\u00f6nder","to":"\u0130le","updated_at":"G\u00fcncellendi","value":"De\u011fer","yes_delete":"evet, sil!","zipcode":"Posta kodu"},"countries":"\u00dclkeler","currency":{"add_currency":"Para Birimi Ekle","currency":"Para Birimi","currency_code":"Para Birimi Kodu","edit_currency":"Para Birimi D\u00fczenle","icon":"Simge"},"currency_reports":"D\u00f6viz Raporlar\u0131","dashboard":"G\u00f6sterge tablosu","datepicker":{"custom":"Om\u00f6rite aralyk","last_30_days":"So\u0148ky 30 g\u00fcn","last_7_days":"So\u0148ky 7 g\u00fcn","last_month":"Ge\u00e7en ay","last_week":"Ge\u00e7en hafta","this_month":"Bu ay","this_week":"Bu hafta","today":"Bug\u00fcn","yesterday":"D\u00fc\u00fdn"},"edit_admin":"y\u00f6neticiyi d\u00fczenle","flash":{"Admin_cant_be_deleted":"Admin pozup bolmaz","Admin_deleted_successfully":"Admin \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","Invoice_send_successfully":"Hasap-faktura \u00fcst\u00fcnlikli iberil\u00fd\u00e4r","admin_created_successfully":"Admin \u00fcst\u00fcnlikli d\u00f6redildi","admin_profile_updated_successfully":"Admin tertibi \u00fcst\u00fcnlikli t\u00e4zelendi","admin_updated_successfully":"Admin \u00fcst\u00fcnlikli t\u00e4zelendi","all_notification_read_successfully":"Allhli habarnamalar \u00fcst\u00fcnlikli okaldy","allowed_file_types_png_jpg_jpeg":"Rugsat berlen fa\u00fdl g\u00f6rn\u00fc\u015fleri: png, jpg, jpeg.","application_cache_cleared":"Programma ke\u015fi arassalandy!","are_sure_want_to_delete_this_client_related_all_invoices":"Bu m\u00fc\u015fteriyle ilgili t\u00fcm faturalar\u0131 silmek istedi\u011finizden emin misiniz?","category_cant_deleted":"Kategori silinemez.","category_deleted_successfully":"Kategori\u00fda \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","category_retrieved_successfully":"Kategori\u00fda \u00fcst\u00fcnlikli alyndy","category_saved_successfully":"Kategori\u00fda \u00fcst\u00fcnlikli saklandy","category_updated_successfully":"Kategori\u00fda \u00fcst\u00fcnlikli t\u00e4zelendi","cities_retrieved_successfully":"\u015e\u00e4herler \u00fcst\u00fcnlikli alyndy","click_refresh_icon_generate_product_code":"\u00d6n\u00fcm kody d\u00f6retmek \u00fc\u00e7in t\u00e4zeleme ny\u015fanyna basy\u0148","client_cant_deleted":"\u0130stemci silinemez.","client_created_successfully":"M\u00fc\u015fderi \u00fcst\u00fcnlikli d\u00f6redildi","client_deleted_successfully":"M\u00fc\u015fderi \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","client_updated_successfully":"M\u00fc\u015fderi \u00fcst\u00fcnlikli t\u00e4zelendi","converted_quote_can_not_editable":"\u00d6w\u00fcrilen sitata redaktirl\u00e4p bolma\u00fdar","converted_to_invoice_successfully":"Hasap-faktura \u00fcst\u00fcnlikli \u00f6wr\u00fcldi","currency_cant_deleted":"Bu Para Birimi ba\u015fka bir yerde kullan\u0131l\u0131yor.","currency_deleted_successfully":"Wal\u00fduta \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","currency_saved_successfully":"Wal\u00fduta \u00fcst\u00fcnlikli tyg\u015fytlandy.","currency_updated_successfully":"Wal\u00fduta \u00fcst\u00fcnlikli t\u00e4zelendi","current_password_is_invalid":"H\u00e4zirki parol n\u00e4dogry","default_admin_can_not_editable":"Bellenen administrator redaktirl\u00e4p bilme\u00fd\u00e4r","invoice_currency_retrieved_successfully":"Hasap-faktura wal\u00fdutasy \u00fcst\u00fcnlikli alyndy","invoice_deleted_successfully":"Hasap-faktura \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","invoice_due_amount_retrieve_successfully":"Hasap-faktura \u00fcst\u00fcnlikli alyndy","invoice_saved_and_sent_successfully":"Hasap-faktura \u00fdatda saklandy we \u00fcst\u00fcnlikli iberildi","invoice_saved_successfully":"Hasap-faktura \u00fcst\u00fcnlikli \u00fdatda saklandy","invoice_template_updated_successfully":"Hasap-faktura \u015fablony \u00fcst\u00fcnlikli t\u00e4zelendi","invoice_updated_and_send_successfully":"Hasap-faktura t\u00e4zelendi we \u00fcst\u00fcnlikli iberildi","invoice_updated_successfully":"Hasap-faktura \u00fcst\u00fcnlikli t\u00e4zelendi","language_updated_successfully":"Dil \u00fcst\u00fcnlikli t\u00e4zelendi","manual_payment_approved_successfully":"El bilen t\u00f6leg \u00fcst\u00fcnlikli tassyklandy","manual_payment_denied_successfully":"El bilen t\u00f6leg \u00fcst\u00fcnlikli ret edildi","note_retrieved_successfully":"Bellik \u00fcst\u00fcnlikli alyndy","notification_read_successfully":"Du\u00fddury\u015f \u00fcst\u00fcnlikli okal\u00fdar","number_of_days_for_recurring_cycle":"Ga\u00fdtalan\u00fdan sikl \u00fc\u00e7in g\u00fcnleri\u0148 sany","password_updated_successfully":"Parol \u00fcst\u00fcnlikli t\u00e4zelendi","payment_deleted_successfully":"T\u00f6leg \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi.","payment_overview_status_retrieved_successfully":"PaymentOverview \u00fdagda\u00fdy \u00fcst\u00fcnlikli alyndy","payment_qr_code_deleted_successfully":"T\u00f6leg qr kody \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","payment_qr_code_saved_successfully":"T\u00f6leg qr kody \u00fcst\u00fcnlikli saklandy","payment_qr_code_status_updated_successfully":"T\u00f6leg qr kody \u00fdagda\u00fdy \u00fcst\u00fcnlikli t\u00e4zelendi","payment_qr_code_updated_successfully":"T\u00f6leg qr kody \u00fcst\u00fcnlikli t\u00e4zelendi","payment_reminder_mail_send_successfully":"T\u00f6leg \u00fdatlatma haty \u00fcst\u00fcnlikli iberildi","payment_saved_successfully":"T\u00f6leg \u00fcst\u00fcnlikli tyg\u015fytlandy.","payment_updated_successfully":"T\u00f6leg \u00fcst\u00fcnlikli t\u00e4zelendi.","product_cant_deleted":"\u00dcr\u00fcn silinemez.","product_created_successfully":"\u00d6n\u00fcm \u00fcst\u00fcnlikli d\u00f6redildi","product_deleted_successfully":"\u00d6n\u00fcm \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","product_price_retrieved_successfully":"\u00d6n\u00fcmi\u0148 bahasy \u00fcst\u00fcnlikli alyndy","product_updated_successfully":"\u00d6n\u00fcm \u00fcst\u00fcnlikli t\u00e4zelendi","quote_deleted_successfully":"Sitata \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","quote_saved_successfully":"Sitata \u00fcst\u00fcnlikli saklandy","quote_updated_successfully":"Sitata \u00fcst\u00fcnlikli t\u00e4zelendi","recurring_status_updated_successfully":"Urrygy-\u00fdygydan \u00fdagda\u00fd \u00fcst\u00fcnlikli t\u00e4zelendi","seems_you_are_not_allowed_to_access_this_record":"G\u00f6rn\u00fc\u015fi \u00fdaly, bu \u00fdazga girm\u00e4ge rugsat berilme\u00fd\u00e4r.","select_currency":"Wal\u00fduta sa\u00fdla\u0148","select_payment_qr_code":"T\u00f6leg QR koduny sa\u00fdla\u0148","select_product_or_enter_free_text":"\u00d6n\u00fcmi sa\u00fdla\u0148 \u00fda-da mugt tekst girizi\u0148","setting_updated_successfully":"\u00dcst\u00fcnlikli t\u00e4zelen\u00fd\u00e4r","status_retrieved_successfully":"Statusagda\u00fd \u00fcst\u00fcnlikli alyndy","status_updated_successfully":"Statusagda\u00fd \u00fcst\u00fcnlikli t\u00e4zelendi","tax_can_not_deleted":"Vergi silinemez.","tax_deleted_successfully":"Salgyt \u00fcst\u00fcnlikli \u00f6\u00e7\u00fcrildi","tax_retrieved_successfully":"Salgyt \u00fcst\u00fcnlikli alyndy","tax_saved_successfully":"Salgyt \u00fcst\u00fcnlikli tyg\u015fytlandy","tax_updated_successfully":"Salgyt \u00fcst\u00fcnlikli t\u00e4zelendi","yearly_income_overview_chart_data_retrieved_successfully":"Incomeyllyk girdeji synyny\u0148 diagramma maglumatlary \u00fcst\u00fcnlikli alyndy"},"general":"Genel","invoice":{"add":"Ekle","add_note_term":"Not ve \u015eartlar Ekle","amount":"Miktar","amount_should_be_less_than_payable_amount":"Tutar, \u00f6denecek tutardan az olmal\u0131d\u0131r.","are_you_sure_send":"Bu faturay\u0131 m\u00fc\u015fteriye g\u00f6ndermek istedi\u011finizden emin misiniz?","client":"M\u00fc\u015fteri","client_email":"M\u00fc\u015fteri E-postas\u0131","client_name":"M\u00fc\u015fteri Ad\u0131","client_overview":"M\u00dc\u015eTER\u0130YE GENEL BAKI\u015e","copy_invoice_url":"Fatura URL'sini Kopyala","discount":"\u0130ndirim","discount_type":"\u0130ndirim T\u00fcr\u00fc","download":"\u0130ndir","due_amount":"\u00d6denmesi Gereken Tutar","due_date":"Son Tarih","edit_invoice":"Faturay\u0131 D\u00fczenle","excel_export":"Excel D\u0131\u015fa Aktarma","fax_no":"faks numaras\u0131","has_been_sent":"g\u00f6nderildi.","invoice":"Fatura","invoice_date":"Fatura Tarihi","invoice_details":"Fatura Ayr\u0131nt\u0131lar\u0131","invoice_id":"Fatura Kimli\u011fi","invoice_number":"Fatura numaras\u0131","invoice_pdf":"Fatura","invoice_url":"fatura url'si","issue_by":"Yay\u0131nlayan","issue_for":"Sorun \u0130\u00e7in","last_recurring_on":"Son Yinelenen A\u00e7\u0131k","make_payment":"\u00d6deme yapmak","new_invoice":"Yeni Fatura","note":"Not","note_not_found":"Not Bulunamad\u0131","note_terms":"Not ve \u015eartlar","nothing_amount_yet":"Hen\u00fcz bir miktar yok.","nothing_due_yet":"Hen\u00fcz bir \u015fey yok.","nothing_paid_yet":"Hen\u00fcz hi\u00e7bir \u015fey \u00f6denmedi.","overview":"Genel bak\u0131\u015f","paid":"\u00dccretli","paid_amount":"\u00d6denen Tutar","parent_invoice":"Veli Fatura","payment":"\u00d6deme","payment_history":"\u00d6deme Ge\u00e7mi\u015fi","payment_method":"\u00d6deme Y\u00f6ntemi","payment_reminder_mail":"\u00d6deme Hat\u0131rlatma Postas\u0131","price":"Fiyat","print_invoice":"Fatura Yazd\u0131r","qty":"adet","recurring":"Yinelenen","recurring_cycle":"Yinelenen D\u00f6ng\u00fc","recurring_invoices":"Yinelenen Faturalar","remaining_amount":"Kalan Tutar","remove_note_term":"Notu ve Ko\u015fullar\u0131 Kald\u0131r","send":"G\u00f6nder","send_invoice":"Fatura G\u00f6nder","start_recurring":"Tekrarlamaya ba\u015fla","stop_recurring":"tekrarlamay\u0131 durdur","sub_total":"Alt Toplam","tax":"Vergi","terms":"\u015eartlar","terms_not_found":"Terim Bulunamad\u0131","total":"Toplam","total_tax":"Vergi","transactions":"\u0130\u015flemler","yes_send":"Evet, G\u00f6nder"},"invoice_templates":"Fatura \u015eablonlar\u0131","invoices":"Faturalar","item":"Haryt","language":"Dil","login":{"email":"E-po\u00e7ta iberi\u0148","forget_your_password":"Paroly\u0148yzy \u00fdatdan \u00e7ykardy\u0148yzmy?","login":"Giri\u015f","password":"Parol","remember_me":"Meni \u00fdatla","sign_in":"Giri\u0148"},"months":{"apr":"Nisan","aug":"a\u011fustos","dec":"Aral\u0131k","feb":"\u015eubat","jan":"Ocak","jul":"Temmuz","jun":"Haziran","mar":"Mart","may":"May\u0131s","nov":"kas\u0131m","oct":"Ekim","sep":"Eyl\u00fcl"},"no_records_found":"Recordsazgylar tapylmady.","notification":{"mark_all_as_read":"T\u00fcm\u00fcn\u00fc Okundu Olarak \u0130\u015faretle","notifications":"Bildirimler","you_don`t_have_any_new_notification":"Yeni bildiriminiz yok"},"paid_invoices":"T\u00f6legli hasap-fakturalar","payment":{"add_payment":"\u00d6deme Ekle","edit_payment":"\u00d6demeyi D\u00fczenle","payable_amount":"\u00d6denecek Tutar","payment_amount":"\u00d6deme Tutar\u0131","payment_date":"\u00d6deme Tarihi","payment_method":"\u00d6deme \u015fekli","payment_mode":"\u00d6deme Modu","payment_type":"\u00d6deme T\u00fcr\u00fc","transaction_id":"\u0130\u015flem Kimli\u011fi","transaction_notes":"\u0130\u015flem Notlar\u0131"},"payment-gateway":"\u00d6deme Sa\u011flay\u0131c\u0131","payment_qr_codes":{"action":"Hereket","add_qr":"Qr go\u015f","add_qr_code":"QR kod go\u015fu\u0148","default":"Bellenen","edit_qr_code":"QR koduny redaktirl\u00e4\u0148","payment_qr_code":"T\u00f6leg QR kody","payment_qr_codes":"T\u00f6leg QR kodlary","qr_code":"QR kody","qr_image":"QR Surat","title":"Ady"},"payments":"\u00f6demeler","pdf_export":"PDF D\u0131\u015fa Aktarma","placeholder":{"invalid_country_number":"N\u00e4dogry \u00fdurt belgisi","invalid_number":"N\u00e4dogry san","select_tax":"Salgyt sa\u00fdla\u0148","too_long":"\u00d6r\u00e4n uzyn","too_short":"Gaty gysga","valid_number":"Dogry belgisi"},"product":{"add_product":"\u00dcr\u00fcn Ekle","category":"Kategori","code":"\u00dcr\u00fcn Kodu","description":"A\u00e7\u0131klama","edit_product":"\u00dcr\u00fcn\u00fc D\u00fczenle","image":"Resim","name":"Ad","price":"Fiyat","product":"\u00dcr\u00fcn","product_details":"\u00dcr\u00fcn Detaylar\u0131","product_name":"\u00dcr\u00fcn Ad\u0131","unit_price":"Birim Fiyat","updated_at":"G\u00fcncelleme Tarihi"},"products":"\u00dcr\u00fcnler","quote":{"add":"Ekle","add_note_term":"Not ve \u015eartlar Ekle","amount":"Miktar","client":"M\u00fc\u015fteri","client_email":"M\u00fc\u015fteri E-postas\u0131","client_id_required":"M\u00fc\u015fteri Kimli\u011fi gereklidir.","client_name":"M\u00fc\u015fteri Ad\u0131","client_overview":"M\u00dc\u015eTER\u0130YE GENEL BAKI\u015e","convert_to_invoice":"Faturaya D\u00f6n\u00fc\u015ft\u00fcr","discount":"\u0130ndirim","discount_type":"\u0130ndirim T\u00fcr\u00fc","download":"\u0130ndir","due_amount":"\u00d6denmesi Gereken Tutar","due_date":"Son Tarih","edit_quote":"Al\u0131nt\u0131y\u0131 D\u00fczenle","excel_export":"Excel D\u0131\u015fa Aktarma","issue_by":"Yay\u0131nlayan","issue_for":"Sorun \u0130\u00e7in","make_payment":"\u00d6deme yapmak","new_quote":"Yeni Al\u0131nt\u0131","note":"Not","note_not_found":"Not Bulunamad\u0131","note_terms":"Not ve \u015eartlar","overview":"Genel bak\u0131\u015f","paid":"\u00dccretli","paid_amount":"\u00d6denen Tutar","payment":"\u00d6deme","payment_history":"\u00d6deme Ge\u00e7mi\u015fi","payment_method":"\u00d6deme Y\u00f6ntemi","price":"Fiyat","print_quote":"Al\u0131nt\u0131 Yazd\u0131r","qty":"adet","quote":"Al\u0131nt\u0131","quote_date":"Teklif Tarihi","quote_details":"Teklif Ayr\u0131nt\u0131lar\u0131","quote_id":"Al\u0131nt\u0131 Kimli\u011fi","quote_name":"Al\u0131nt\u0131","quote_number":"Teklif Numaras\u0131","quote_pdf":"Al\u0131nt\u0131","quote_url":"Al\u0131nt\u0131 URL","recurring":"Yinelenen","remaining_amount":"Kalan Tutar","remove_note_term":"Notu ve Ko\u015fullar\u0131 Kald\u0131r","sub_total":"Alt Toplam","tax":"Vergi","terms":"\u015eartlar","terms_not_found":"Terim Bulunamad\u0131","total":"Toplam","total_tax":"Vergi","transactions":"\u0130\u015flemler"},"quotes":"al\u0131nt\u0131lar","received_amount":"Alnan mukdar","registered_date":"Hasaba alnan senesi","roles":"Roller","setting":{"address":"Adres","app_logo":"Uygulama Logosu","app_name":"Uygulama Ad\u0131","auto_approve":"Otomatik Onay","clinic_name":"Klinik Ad\u0131","color":"Renk","company_address":"\u015eirket Adresi","company_image_validation":"G\u00f6r\u00fcnt\u00fc 210 x 50 piksel boyutunda olmal\u0131d\u0131r.","company_logo":"\u015eirket Logosu","company_name":"\u015eirket Ad\u0131","company_phone":"\u015eirket Telefonu","contact_information":"\u0130leti\u015fim Bilgileri","country_code":"\u00dclke Kodu","currencies":"para birimleri","currency_position":"Para Birimi Pozisyonu","currency_settings":"Para Birimi Ayarlar\u0131","date_format":"Tarih Format\u0131","decimal_separator":"Ondal\u0131k Ay\u0131r\u0131c\u0131","fav_icon":"Favicon","general":"Genel","general_details":"Genel Ayr\u0131nt\u0131lar","image_validation":"G\u00f6r\u00fcnt\u00fc 90 x 60 piksel boyutunda olmal\u0131d\u0131r.","invoice_no_prefix":"Fatura \u00d6neki Yok","invoice_no_suffix":"Fatura Son Eki Yok","invoice_settings":"Fatura Ayarlar\u0131","invoice_template":"Fatura \u015eablonu","mail_notifications":"Posta Bildirimleri","manuel_payment_approval":"Manuel \u00d6deme Onay\u0131","payment_approved":"T\u00f6leg tassyklandy","payment_auto_approved":"Otomatik \u00f6deme onay\u0131","paypal":"PayPal","paypal_client_id":"Paypal M\u00fc\u015fteri Kimli\u011fi","paypal_secret":"Paypal S\u0131rr\u0131","postal_code":"Posta Kodu","prefix":"\u00d6n ek","razorpay":"Razorpay","razorpay_key":"Razorpay Anahtar\u0131","razorpay_secret":"Razorpay Gizli","send_due_invoice_email_before_x_days":"Vadesi Gelen Fatura E-postas\u0131n\u0131 X G\u00fcnden \u00d6nce G\u00f6nderin","setting":"Ayar","show_additional_address":"Faturada Ek Adresi G\u00f6ster","show_currency_behind":"Arkadaki Para Birimi G\u00f6ster","show_product_description":"\u00dcr\u00fcn A\u00e7\u0131klamas\u0131n\u0131 G\u00f6ster","specialities":"Uzmanl\u0131klar","stripe":"\u015ferit","stripe_key":"\u015eerit Anahtar","stripe_secret":"\u015ferit s\u0131r","thousand_separator":"Bin Ay\u0131r\u0131c\u0131","time_format":"Zaman Format\u0131","timezone":"Saat Dilimi"},"settings":"Ayarlar","sign_out":"Oturumu Kapat","states":"Devletler","tax":{"add_tax":"Vergi Ekle","edit_tax":"Vergiyi D\u00fczenle","is_default":"Varsay\u0131lan","no":"Hay\u0131r","tax":"Vergi","yes":"Evet"},"tax_information":"Vergi bilgisi","taxes":"Vergiler","transactions":"\u0130\u015flemler","unpaid_invoices":"T\u00f6lenmedik hasap-fakturalar","user":{"account":"Hesap","account_setting":"Hesap Ayarlar\u0131","avatar":"Avatar","change_password":"\u015eifreyi De\u011fi\u015ftir","confirm_password":"\u015eifreyi Onayla","contact_number":"\u0130leti\u015fim Numaras\u0131","current_password":"Ge\u00e7erli \u015eifre","email":"E-posta","full_name":"Tam Ad","gender":"Cinsiyet","new_password":"Yeni \u015eifre","phone":"Telefon","phone_number":"Telefon numaras\u0131","profile":"Profil","profile_details":"Profil Ayr\u0131nt\u0131lar\u0131","save_changes":"De\u011fi\u015fiklikleri Kaydet","setting":"Ayar","user_details":"Kullan\u0131c\u0131 Ayr\u0131nt\u0131lar\u0131"},"users":"Kullan\u0131c\u0131lar","weekdays":{"fri":"Cuma","mon":"AY","sat":"Oturdu","sun":"G\u00dcNE\u015e","thu":"PHU","tue":"sal","wed":"EVLENMEK"}},"zh.messages":{"add_admin":"\u6dfb\u52a0\u7ba1\u7406\u5458","admin":"\u884c\u653f","admin_dashboard":{"dashboard":"\u4eea\u8868\u677f","day":"\u5929","income_overview":"\u6536\u5165\u6982\u89c8","invoice_overview":"\u53d1\u7968\u6982\u89c8","month":"\u6708","monthly_income_overview":"\u6bcf\u6708\u6536\u5165\u6982\u89c8","name":"\u59d3\u540d","no_record_found":"\u672a\u627e\u5230\u8bb0\u5f55","payment_overview":"\u4ed8\u6b3e\u6982\u89c8","registered":"\u6ce8\u518c","total_amount":"\u603b\u91d1\u989d","total_clients":"\u603b\u5ba2\u6237","total_due":"\u603b\u5230\u671f","total_invoices":"\u603b\u53d1\u7968","total_overdue_invoice":"\u603b\u903e\u671f\u53d1\u7968","total_paid":"\u603b\u652f\u4ed8","total_paid_invoices":"\u603b\u5df2\u4ed8\u53d1\u7968","total_partial_paid_invoices":"\u90e8\u5206\u652f\u4ed8\u7684\u603b\u53d1\u7968","total_payments":"\u603b\u4ed8\u6b3e","total_products":"\u603b\u4ea7\u54c1","total_unpaid_invoices":"\u603b\u672a\u4ed8\u53d1\u7968","week":"\u5468","year":"\u5e74","yearly_income_overview":"\u5e74\u6536\u5165\u6982\u89c8"},"admin_details":"\u7ba1\u7406\u5458\u8be6\u60c5","admins":"\u7ba1\u7406\u5458","apps":"\u5e94\u7528\u7a0b\u5e8f","categories":"\u7c7b\u522b","category":{"add_category":"\u6dfb\u52a0\u7c7b\u522b","category":"\u7c7b\u522b","edit_category":"\u7f16\u8f91\u7c7b\u522b"},"change_avatar":"\u66f4\u6539\u5934\u50cf","change_language":"\u6539\u8b8a\u8a9e\u8a00","cities":"\u57ce\u5e02","clear_cache":"\u6e05\u9664\u7f13\u5b58","client":{"add_client":"\u6dfb\u52a0\u5ba2\u6237\u7aef","add_user":"\u6dfb\u52a0\u7528\u6237","address":"\u5730\u5740","city":"\u57ce\u5e02","client":"\u5ba2\u6237","client_details":"\u5ba2\u6237\u8be6\u60c5","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_no":"\u8054\u7cfb\u53f7\u7801","country":"\u56fd\u5bb6","created_at":"\u65e5\u671f","edit_user":"\u7f16\u8f91\u7528\u6237","email":"\u7535\u5b50\u90ae\u4ef6","female":"\u5973","first_name":"\u540d\u5b57","gender":"\u6027\u522b","last_name":"\u59d3\u6c0f","male":"\u7537","note":"\u6ce8\u610f","notes":"\u6ce8\u91ca","password":"\u5bc6\u7801","postal_code":"\u90ae\u653f\u7f16\u7801","profile":"\u4e2a\u4eba\u8d44\u6599","role":"\u89d2\u8272","state":"\u72b6\u6001","website":"\u7f51\u7ad9"},"client_address":"\u5ba2\u6237\u5730\u5740","clients":"\u5ba2\u6237","common":{"action":"\u52a8\u4f5c","actions":"\u52a8\u4f5c","active":"\u6d3b\u8dc3","add":"\u6dfb\u52a0","address":"\u5730\u5740","allow_file_type":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b","apply":"\u7533\u8bf7","are_you_sure_delete":"\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u4e2a\u5417","attachment":"\u9644\u4ef6","back":"\u8fd4\u56de","cancel":"\u53d6\u6d88","city":"\u57ce\u5e02","click_here":"\u70b9\u51fb\u8fd9\u91cc","country":"\u56fd\u5bb6","created_at":"\u521b\u5efa","custom":"\u98ce\u4fd7","de_active":"\u4e0d\u6d3b\u8dc3","default":"\u9ed8\u8ba4","delete":"\u5220\u9664","deleted":"\u5df2\u5220\u9664!","details":"\u8be6\u60c5","discard":"\u4e22\u5f03","edit":"\u7f16\u8f91","email":"\u7535\u5b50\u90ae\u4ef6","error":"\u9519\u8bef","filter":"\u8fc7\u6ee4\u5668","filter_options":"\u8fc7\u6ee4\u5668\u9009\u9879","from":"\u4ece","has_been_deleted":"\u5df2\u88ab\u5220\u9664.","invoice":"\u53d1\u7968","last_update":"\u6700\u540e\u66f4\u65b0","mo":"\u83ab","n\/a":"\u4e0d\u9002\u7528","name":"\u59d3\u540d","no_cancel":"\u4e0d\uff0c\u53d6\u6d88","ok":"\u597d\u7684","pay":"\u652f\u4ed8","payment_type":"\u4ed8\u6b3e\u7c7b\u578b","please_wait":"\u8bf7\u7a0d\u5019...","regards":"\u95ee\u5019","reminder":"\u63d0\u9192","reset":"\u91cd\u7f6e","save":"\u4fdd\u5b58","save_draft":"\u53e6\u5b58\u4e3a\u8349\u7a3f","save_send":"\u4fdd\u5b58\u5e76\u53d1\u9001","search":"\u641c\u7d22","service":"\u670d\u52a1","state":"\u72b6\u6001","status":"\u72b6\u6001","submit":"\u63d0\u4ea4","to":"\u81f3","updated_at":"\u66f4\u65b0","value":"\u4ef7\u503c","yes_delete":"\u662f\u7684\uff0c\u5220\u9664!","zipcode":"\u90ae\u653f\u7f16\u7801"},"countries":"\u56fd\u5bb6","currency":{"add_currency":"\u6dfb\u52a0\u8d27\u5e01","currency":"\u8d27\u5e01","currency_code":"\u8d27\u5e01\u4ee3\u7801","edit_currency":"\u7f16\u8f91\u8d27\u5e01","icon":"\u56fe\u6807"},"currency_reports":"\u8d27\u5e01\u62a5\u544a","dashboard":"\u4eea\u8868\u677f","datepicker":{"custom":"\u81ea\u5b9a\u4e49\u8303\u56f4","last_30_days":"\u8fc7\u53bb 30 \u5929","last_7_days":"\u8fc7\u53bb 7 \u5929","last_month":"\u4e0a\u4e2a\u6708","last_week":"\u4e0a\u5468","this_month":"\u8fd9\u4e2a\u6708","this_week":"\u672c\u661f\u671f","today":"\u4eca\u5929","yesterday":"\u6628\u5929"},"edit_admin":"\u7f16\u8f91\u7ba1\u7406\u5458","flash":{"Admin_cant_be_deleted":"\u7ba1\u7406\u5458\u65e0\u6cd5\u5220\u9664","Admin_deleted_successfully":"\u7ba1\u7406\u5458\u5220\u9664\u6210\u529f","Invoice_send_successfully":"\u53d1\u7968\u53d1\u9001\u6210\u529f","admin_created_successfully":"\u7ba1\u7406\u5458\u521b\u5efa\u6210\u529f","admin_profile_updated_successfully":"\u7ba1\u7406\u5458\u4e2a\u4eba\u8d44\u6599\u66f4\u65b0\u6210\u529f","admin_updated_successfully":"\u7ba1\u7406\u5458\u66f4\u65b0\u6210\u529f","all_notification_read_successfully":"\u6240\u6709\u901a\u77e5\u8bfb\u53d6\u6210\u529f","allowed_file_types_png_jpg_jpeg":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","application_cache_cleared":"\u5e94\u7528\u7a0b\u5e8f\u7f13\u5b58\u5df2\u6e05\u9664\uff01","are_sure_want_to_delete_this_client_related_all_invoices":"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u4e0e\u8be5\u5ba2\u6237\u76f8\u5173\u7684\u6240\u6709\u53d1\u7968\u5417\uff1f","category_cant_deleted":"\u7c7b\u522b\u4e0d\u80fd\u5220\u9664","category_deleted_successfully":"\u7c7b\u522b\u5220\u9664\u6210\u529f","category_retrieved_successfully":"\u7c7b\u522b\u68c0\u7d22\u6210\u529f","category_saved_successfully":"\u7c7b\u522b\u4fdd\u5b58\u6210\u529f","category_updated_successfully":"\u7c7b\u522b\u66f4\u65b0\u6210\u529f","cities_retrieved_successfully":"\u57ce\u5e02\u68c0\u7d22\u6210\u529f","click_refresh_icon_generate_product_code":"\u70b9\u51fb\u5237\u65b0\u56fe\u6807\u751f\u6210\u4ea7\u54c1\u4ee3\u7801","client_cant_deleted":"\u65e0\u6cd5\u5220\u9664\u5ba2\u6237\u7aef\u3002","client_created_successfully":"\u5ba2\u6237\u7aef\u521b\u5efa\u6210\u529f","client_deleted_successfully":"\u5ba2\u6237\u7aef\u5220\u9664\u6210\u529f","client_updated_successfully":"\u5ba2\u6237\u7aef\u66f4\u65b0\u6210\u529f","converted_quote_can_not_editable":"\u8f6c\u6362\u540e\u7684\u62a5\u4ef7\u4e0d\u53ef\u7f16\u8f91","converted_to_invoice_successfully":"\u5df2\u6210\u529f\u8f6c\u6362\u4e3a\u53d1\u7968","currency_cant_deleted":"\u8fd9\u79cd\u8d27\u5e01\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u3002","currency_deleted_successfully":"\u8d27\u5e01\u5220\u9664\u6210\u529f","currency_saved_successfully":"\u8d27\u5e01\u4fdd\u5b58\u6210\u529f\u3002","currency_updated_successfully":"\u8d27\u5e01\u66f4\u65b0\u6210\u529f","current_password_is_invalid":"\u5f53\u524d\u5bc6\u7801\u65e0\u6548","default_admin_can_not_editable":"\u9ed8\u8ba4\u7ba1\u7406\u5458\u65e0\u6cd5\u7f16\u8f91","invoice_currency_retrieved_successfully":"\u53d1\u7968\u5e01\u79cd\u68c0\u7d22\u6210\u529f","invoice_deleted_successfully":"\u53d1\u7968\u5220\u9664\u6210\u529f","invoice_due_amount_retrieve_successfully":"\u53d1\u7968\u5230\u671f\u91d1\u989d\u5df2\u6210\u529f\u68c0\u7d22","invoice_saved_and_sent_successfully":"\u53d1\u7968\u5df2\u4fdd\u5b58\u5e76\u6210\u529f\u53d1\u9001","invoice_saved_successfully":"\u53d1\u7968\u4fdd\u5b58\u6210\u529f","invoice_template_updated_successfully":"\u53d1\u7968\u6a21\u677f\u66f4\u65b0\u6210\u529f","invoice_updated_and_send_successfully":"\u53d1\u7968\u5df2\u66f4\u65b0\u5e76\u6210\u529f\u53d1\u9001","invoice_updated_successfully":"\u53d1\u7968\u66f4\u65b0\u6210\u529f","language_updated_successfully":"\u8bed\u8a00\u66f4\u65b0\u6210\u529f","manual_payment_approved_successfully":"\u624b\u52a8\u4ed8\u6b3e\u6279\u51c6\u6210\u529f","manual_payment_denied_successfully":"\u624b\u52a8\u4ed8\u6b3e\u88ab\u6210\u529f\u62d2\u7edd","note_retrieved_successfully":"\u6ce8\u91ca\u68c0\u7d22\u6210\u529f","notification_read_successfully":"\u901a\u77e5\u8bfb\u53d6\u6210\u529f","number_of_days_for_recurring_cycle":"\u91cd\u590d\u5468\u671f\u7684\u5929\u6570","password_updated_successfully":"\u5bc6\u7801\u66f4\u65b0\u6210\u529f","payment_deleted_successfully":"\u4ed8\u6b3e\u5220\u9664\u6210\u529f\u3002","payment_overview_status_retrieved_successfully":"PaymentOverview \u72b6\u6001\u68c0\u7d22\u6210\u529f","payment_qr_code_deleted_successfully":"\u652f\u4ed8\u4e8c\u7ef4\u7801\u5220\u9664\u6210\u529f","payment_qr_code_saved_successfully":"\u652f\u4ed8\u4e8c\u7ef4\u7801\u4fdd\u5b58\u6210\u529f","payment_qr_code_status_updated_successfully":"\u652f\u4ed8\u4e8c\u7ef4\u7801\u72b6\u6001\u66f4\u65b0\u6210\u529f","payment_qr_code_updated_successfully":"\u652f\u4ed8\u4e8c\u7ef4\u7801\u66f4\u65b0\u6210\u529f","payment_reminder_mail_send_successfully":"\u4ed8\u6b3e\u63d0\u9192\u90ae\u4ef6\u53d1\u9001\u6210\u529f","payment_saved_successfully":"\u4ed8\u6b3e\u5df2\u6210\u529f\u4fdd\u5b58\u3002","payment_updated_successfully":"\u4ed8\u6b3e\u66f4\u65b0\u6210\u529f\u3002","product_cant_deleted":"\u4ea7\u54c1\u4e0d\u80fd\u88ab\u5220\u9664\u3002","product_created_successfully":"\u4ea7\u54c1\u521b\u5efa\u6210\u529f","product_deleted_successfully":"\u4ea7\u54c1\u5220\u9664\u6210\u529f","product_price_retrieved_successfully":"\u4ea7\u54c1\u4ef7\u683c\u68c0\u7d22\u6210\u529f","product_updated_successfully":"\u4ea7\u54c1\u66f4\u65b0\u6210\u529f","quote_deleted_successfully":"\u62a5\u4ef7\u5220\u9664\u6210\u529f","quote_saved_successfully":"\u62a5\u4ef7\u4fdd\u5b58\u6210\u529f","quote_updated_successfully":"\u62a5\u4ef7\u66f4\u65b0\u6210\u529f","recurring_status_updated_successfully":"\u5b9a\u671f\u72b6\u6001\u66f4\u65b0\u6210\u529f","seems_you_are_not_allowed_to_access_this_record":"\u770b\u6765\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u8be5\u8bb0\u5f55\u3002","select_currency":"\u9009\u62e9\u8d27\u5e01","select_payment_qr_code":"\u9009\u62e9\u652f\u4ed8\u4e8c\u7ef4\u7801","select_product_or_enter_free_text":"\u9009\u62e9\u4ea7\u54c1\u6216\u8f93\u5165\u81ea\u7531\u6587\u672c","setting_updated_successfully":"\u8bbe\u7f6e\u66f4\u65b0\u6210\u529f","status_retrieved_successfully":"\u72b6\u6001\u68c0\u7d22\u6210\u529f","status_updated_successfully":"\u72b6\u6001\u66f4\u65b0\u6210\u529f","tax_can_not_deleted":"\u7a0e\u6536\u4e0d\u80fd\u88ab\u5220\u9664\u3002","tax_deleted_successfully":"\u7a0e\u6b3e\u5220\u9664\u6210\u529f","tax_retrieved_successfully":"\u7a0e\u6b3e\u68c0\u7d22\u6210\u529f","tax_saved_successfully":"\u7a0e\u6b3e\u4fdd\u5b58\u6210\u529f","tax_updated_successfully":"\u7a0e\u8d39\u66f4\u65b0\u6210\u529f","yearly_income_overview_chart_data_retrieved_successfully":"\u5e74\u6536\u5165\u6982\u89c8\u56fe\u8868\u6570\u636e\u68c0\u7d22\u6210\u529f"},"general":"\u4e00\u822c","invoice":{"add":"\u6dfb\u52a0","add_note_term":"\u6dfb\u52a0\u6ce8\u91ca\u548c\u672f\u8bed","amount":"\u91d1\u989d","amount_should_be_less_than_payable_amount":"\u91d1\u989d\u5e94\u5c0f\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002","are_you_sure_send":"\u60a8\u786e\u5b9a\u8981\u5c06\u6b64\u53d1\u7968\u53d1\u9001\u7ed9\u5ba2\u6237\u5417\uff1f","client":"\u5ba2\u6237","client_email":"\u5ba2\u6237\u7535\u5b50\u90ae\u4ef6","client_name":"\u5ba2\u6237\u7aef\u540d\u79f0","client_overview":"\u5ba2\u6237\u6982\u89c8","copy_invoice_url":"\u590d\u5236\u53d1\u7968 URL","discount":"\u6298\u6263","discount_type":"\u6298\u6263\u7c7b\u578b","download":"\u4e0b\u8f7d","due_amount":"\u5230\u671f\u91d1\u989d","due_date":"\u622a\u6b62\u65e5\u671f","edit_invoice":"\u7f16\u8f91\u53d1\u7968","excel_export":"Excel \u5bfc\u51fa","fax_no":"\u4f20\u771f\u53f7","has_been_sent":"\u5df2\u53d1\u9001\u3002","invoice":"\u53d1\u7968","invoice_date":"\u53d1\u7968\u65e5\u671f","invoice_details":"\u53d1\u7968\u660e\u7ec6","invoice_id":"\u53d1\u7968\u7f16\u53f7","invoice_number":"\u53d1\u7968\u53f7\u7801","invoice_pdf":"\u53d1\u7968","invoice_url":"\u53d1\u7968\u7f51\u5740","issue_by":"\u53d1\u5e03\u8005","issue_for":"\u95ee\u9898\u4e3a","last_recurring_on":"\u4e0a\u6b21\u91cd\u590d\u65f6\u95f4","make_payment":"\u4ed8\u6b3e","new_invoice":"\u65b0\u53d1\u7968","note":"\u6ce8\u610f","note_not_found":"\u627e\u4e0d\u5230\u7b14\u8bb0","note_terms":"\u6ce8\u610f\u548c\u6761\u6b3e","nothing_amount_yet":"\u8fd8\u6ca1\u6709\u4ec0\u4e48\u91d1\u989d\u3002","nothing_due_yet":"\u8fd8\u6ca1\u6709\u5230\u671f\u3002","nothing_paid_yet":"\u8fd8\u6ca1\u4ed8\u94b1\u3002","overview":"\u6982\u89c8","paid":"\u4ed8\u8d39","paid_amount":"\u652f\u4ed8\u91d1\u989d","parent_invoice":"\u5bb6\u957f\u53d1\u7968","payment":"\u4ed8\u6b3e","payment_history":"\u4ed8\u6b3e\u5386\u53f2","payment_method":"\u4ed8\u6b3e\u65b9\u5f0f","payment_reminder_mail":"\u4ed8\u6b3e\u63d0\u9192\u90ae\u4ef6","price":"\u4ef7\u683c","print_invoice":"\u6253\u5370\u53d1\u7968","qty":"\u6570\u91cf","recurring":"\u518d\u6b21\u53d1\u751f\u7684","recurring_cycle":"\u5faa\u73af\u5468\u671f","recurring_invoices":"\u7ecf\u5e38\u6027\u53d1\u7968","remaining_amount":"\u5269\u4f59\u91d1\u989d","remove_note_term":"\u5220\u9664\u6ce8\u91ca\u548c\u6761\u6b3e","send":"\u53d1\u9001","send_invoice":"\u53d1\u9001\u53d1\u7968","start_recurring":"\u5f00\u59cb\u91cd\u590d","stop_recurring":"\u505c\u6b62\u91cd\u590d","sub_total":"\u5c0f\u8ba1","tax":"\u7a0e","terms":"\u6761\u6b3e","terms_not_found":"\u672a\u627e\u5230\u6761\u6b3e","total":"\u603b\u8ba1","total_tax":"\u7a0e","transactions":"\u4ea4\u6613","yes_send":"\u662f\u7684\uff0c\u53d1\u9001"},"invoice_templates":"\u53d1\u7968\u6a21\u677f","invoices":"\u53d1\u7968","item":"\u7269\u54c1","language":"\u8bed\u8a00","login":{"email":"\u7535\u5b50\u90ae\u4ef6","forget_your_password":"\u5fd8\u8bb0\u5bc6\u7801\u4e86\u5417\uff1f","login":"\u767b\u5f55","password":"\u5bc6\u7801","remember_me":"\u8bb0\u4f4f\u8d26\u53f7","sign_in":"\u767b\u5165"},"months":{"apr":"\u56db\u6708","aug":"\u4e5d\u6708","dec":"\u592a\u9633","feb":"\u4e8c\u6708","jan":"\u7b80","jul":"\u516b\u6708","jun":"\u541b","mar":"\u4e09\u6708","may":"\u53ef\u80fd","nov":"\u5341\u4e8c\u6708","oct":"\u5341\u4e00\u6708","sep":"\u5341\u6708"},"no_records_found":"\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\u3002","notification":{"mark_all_as_read":"\u6807\u8bb0\u4e3a\u5df2\u8bfb","notifications":"\u901a\u77e5","you_don`t_have_any_new_notification":"\u60a8\u6ca1\u6709\u4efb\u4f55\u65b0\u901a\u77e5"},"paid_invoices":"\u5df2\u4ed8\u53d1\u7968","payment":{"add_payment":"\u6dfb\u52a0\u4ed8\u6b3e","edit_payment":"\u7f16\u8f91\u4ed8\u6b3e","payable_amount":"\u5e94\u4ed8\u91d1\u989d","payment_amount":"\u4ed8\u6b3e\u91d1\u989d","payment_date":"\u4ed8\u6b3e\u65e5\u671f","payment_method":"\u4ed8\u6b3e\u65b9\u5f0f","payment_mode":"\u4ed8\u6b3e\u65b9\u5f0f","payment_type":"\u4ed8\u6b3e\u7c7b\u578b","transaction_id":"\u4ea4\u6613ID","transaction_notes":"\u4ea4\u6613\u8bb0\u5f55"},"payment-gateway":"\u652f\u4ed8\u7f51\u5173","payment_qr_codes":{"action":"\u884c\u52a8","add_qr":"\u6dfb\u52a0\u4e8c\u7ef4\u7801","add_qr_code":"\u6dfb\u52a0\u4e8c\u7ef4\u7801","default":"\u9ed8\u8ba4","edit_qr_code":"\u7f16\u8f91\u4e8c\u7ef4\u7801","payment_qr_code":"\u652f\u4ed8\u4e8c\u7ef4\u7801","payment_qr_codes":"\u652f\u4ed8\u4e8c\u7ef4\u7801","qr_code":"\u4e8c\u7ef4\u7801","qr_image":"\u4e8c\u7ef4\u7801\u56fe\u50cf","title":"\u6807\u9898"},"payments":"\u4ed8\u6b3e","pdf_export":"PDF\u5bfc\u51fa","placeholder":{"invalid_country_number":"\u65e0\u6548\u7684\u56fd\u5bb6\u53f7\u7801","invalid_number":"\u65e0\u6548\u53f7\u7801","select_tax":"\u9009\u62e9\u7a0e","too_long":"\u592a\u957f","too_short":"\u8fc7\u77ed","valid_number":"\u6709\u6548\u53f7\u7801"},"product":{"add_product":"\u6dfb\u52a0\u4ea7\u54c1","category":"\u7c7b\u522b","code":"\u4ea7\u54c1\u4ee3\u7801","description":"\u8bf4\u660e","edit_product":"\u7f16\u8f91\u4ea7\u54c1","image":"\u56fe\u50cf","name":"\u59d3\u540d","price":"\u4ef7\u683c","product":"\u4ea7\u54c1","product_details":"\u4ea7\u54c1\u8be6\u60c5","product_name":"\u4ea7\u54c1\u540d\u79f0","unit_price":"\u5355\u4ef7","updated_at":"\u66f4\u65b0\u65f6\u95f4"},"products":"\u4ea7\u54c1","quote":{"add":"\u6dfb\u52a0","add_note_term":"\u6dfb\u52a0\u6ce8\u91ca\u548c\u672f\u8bed","amount":"\u91d1\u989d","client":"\u5ba2\u6237","client_email":"\u5ba2\u6237\u7535\u5b50\u90ae\u4ef6","client_id_required":"\u9700\u8981\u5ba2\u6237\u7aef ID\u3002","client_name":"\u5ba2\u6237\u7aef\u540d\u79f0","client_overview":"\u5ba2\u6237\u6982\u89c8","convert_to_invoice":"In Rechnung umwandeln","discount":"\u6298\u6263","discount_type":"\u6298\u6263\u7c7b\u578b","download":"\u4e0b\u8f7d","due_amount":"\u5230\u671f\u91d1\u989d","due_date":"\u622a\u6b62\u65e5\u671f","edit_quote":"Zitat bearbeiten","excel_export":"Excel \u5bfc\u51fa","issue_by":"\u53d1\u5e03\u8005","issue_for":"\u95ee\u9898\u4e3a","make_payment":"\u4ed8\u6b3e","new_quote":"Neues Zitat","note":"\u6ce8\u610f","note_not_found":"\u627e\u4e0d\u5230\u7b14\u8bb0","note_terms":"\u6ce8\u610f\u548c\u6761\u6b3e","overview":"\u6982\u89c8","paid":"\u4ed8\u8d39","paid_amount":"\u652f\u4ed8\u91d1\u989d","payment":"\u4ed8\u6b3e","payment_history":"\u4ed8\u6b3e\u5386\u53f2","payment_method":"\u4ed8\u6b3e\u65b9\u5f0f","price":"\u4ef7\u683c","print_quote":"Angebot drucken","qty":"\u6570\u91cf","quote":"Zitat","quote_date":"Angebotsdatum","quote_details":"Angebotsdetails","quote_id":"Zitat-ID","quote_name":"\u5f15\u7528","quote_number":"Angebotsnummer","quote_pdf":"Zitat","quote_url":"Zitat-URL","recurring":"\u518d\u6b21\u53d1\u751f\u7684","remaining_amount":"\u5269\u4f59\u91d1\u989d","remove_note_term":"\u5220\u9664\u6ce8\u91ca\u548c\u6761\u6b3e","sub_total":"\u5c0f\u8ba1","tax":"\u7a0e","terms":"\u6761\u6b3e","terms_not_found":"\u672a\u627e\u5230\u6761\u6b3e","total":"\u603b\u8ba1","total_tax":"\u7a0e","transactions":"\u4ea4\u6613"},"quotes":"\u5f15\u53f7","received_amount":"\u6536\u5230\u91d1\u989d","registered_date":"\u6ce8\u518c\u65e5\u671f","roles":"\u89d2\u8272","setting":{"address":"\u5730\u5740","app_logo":"\u5e94\u7528\u6807\u5fd7","app_name":"\u5e94\u7528\u540d\u79f0","auto_approve":"\u81ea\u52a8\u6279\u51c6","clinic_name":"\u8bca\u6240\u540d\u79f0","color":"\u989c\u8272","company_address":"\u516c\u53f8\u5730\u5740","company_image_validation":"\u56fe\u50cf\u7684\u50cf\u7d20\u5fc5\u987b\u4e3a 210 x 50\u3002","company_logo":"\u516c\u53f8\u6807\u5fd7","company_name":"\u516c\u53f8\u540d\u79f0","company_phone":"\u516c\u53f8\u7535\u8bdd","contact_information":"\u8054\u7cfb\u4fe1\u606f","country_code":"\u56fd\u5bb6\u4ee3\u7801","currencies":"\u8d27\u5e01","currency_position":"\u8d27\u5e01\u5934\u5bf8","currency_settings":"\u8d27\u5e01\u8bbe\u7f6e","date_format":"\u65e5\u671f\u683c\u5f0f","decimal_separator":"\u5341\u8fdb\u5236\u5206\u9694\u7b26","fav_icon":"\u6536\u85cf\u5939\u56fe\u6807","general":"\u4e00\u822c","general_details":"\u4e00\u822c\u8be6\u7ec6\u4fe1\u606f","image_validation":"\u56fe\u50cf\u5fc5\u987b\u4e3a 90 x 60 \u50cf\u7d20\u3002","invoice_no_prefix":"\u53d1\u7968\u65e0\u524d\u7f00","invoice_no_suffix":"\u53d1\u7968\u65e0\u540e\u7f00","invoice_settings":"\u53d1\u7968\u8bbe\u7f6e","invoice_template":"\u53d1\u7968\u6a21\u677f","mail_notifications":"\u90ae\u4ef6\u901a\u77e5","manual_payment_approval":"\u4eba\u5de5\u4ed8\u6b3e\u5ba1\u6279","payment_approved":"\u4ed8\u6b3e\u5df2\u6279\u51c6","payment_auto_approved":"\u4ed8\u6b3e\u81ea\u52a8\u5ba1\u6279","paypal":"\u652f\u4ed8\u5b9d","paypal_client_id":"\u8d1d\u5b9d\u5ba2\u6237\u7aef ID","paypal_secret":"\u8d1d\u5b9d\u79d8\u5bc6t","postal_code":"\u90ae\u653f\u7f16\u7801","prefix":"\u524d\u7f00","razorpay":"\u5243\u5200\u652f\u4ed8","razorpay_key":"Razorpay \u5bc6\u94a5","razorpay_secret":"Razorpay \u79d8\u5bc6","send_due_invoice_email_before_x_days":"\u5728 X \u5929\u4e4b\u524d\u53d1\u9001\u5230\u671f\u53d1\u7968\u7535\u5b50\u90ae\u4ef6","setting":"\u8bbe\u7f6e","show_additional_address":"\u5728\u53d1\u7968\u4e2d\u663e\u793a\u5176\u4ed6\u5730\u5740","show_currency_behind":"\u663e\u793a\u8d27\u5e01\u80cc\u540e","show_product_description":"\u663e\u793a\u4ea7\u54c1\u63cf\u8ff0","specialities":"\u4e13\u4e1a","stripe":"\u6761\u7eb9","stripe_key":"\u6761\u7eb9\u952e","stripe_secret":"\u6761\u7eb9\u79d8\u5bc6","thousand_separator":"\u5343\u4f4d\u5206\u9694\u7b26","time_format":"\u65f6\u95f4\u683c\u5f0f","timezone":"\u65f6\u533a"},"settings":"\u8bbe\u7f6e","sign_out":"\u9000\u51fa","states":"\u5dde","tax":{"add_tax":"\u52a0\u7a0e","edit_tax":"\u7f16\u8f91\u7a0e","is_default":"\u662f\u9ed8\u8ba4\u503c","no":"\u4e0d","tax":"\u7a0e","yes":"\u662f"},"tax_information":"\u7a0e\u52a1\u4fe1\u606f","taxes":"\u7a0e\u6536","transactions":"\u4ea4\u6613","unpaid_invoices":"\u672a\u4ed8\u53d1\u7968","user":{"account":"\u8d26\u6237","account_setting":"\u8d26\u6237\u8bbe\u7f6e","avatar":"\u5934\u50cf","change_password":"\u4fee\u6539\u5bc6\u7801","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_number":"\u8054\u7cfb\u7535\u8bdd","current_password":"\u5f53\u524d\u5bc6\u7801","email":"\u7535\u5b50\u90ae\u4ef6","full_name":"\u5168\u540d","gender":"\u6027\u522b","new_password":"\u65b0\u5bc6\u7801","phone":"\u7535\u8bdd","phone_number":"\u7535\u8bdd\u53f7\u7801","profile":"\u4e2a\u4eba\u8d44\u6599","profile_details":"\u4e2a\u4eba\u8d44\u6599\u8be6\u60c5","save_changes":"\u4fdd\u5b58\u66f4\u6539","setting":"\u8bbe\u7f6e","user_details":"\u7528\u6237\u8be6\u7ec6\u4fe1\u606f"},"users":"\u7528\u6237","weekdays":{"fri":"\u5468\u4e94","mon":"\u661f\u671f\u4e00","sat":"\u661f\u671f\u516d","sun":"\u592a\u9633","thu":"\u5468\u56db","tue":"\u5468\u4e8c","wed":"\u661f\u671f\u4e09"}}});
})();
